/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataReliabilityEvaluationInhibit is the corresponding interface of BACnetConstructedDataReliabilityEvaluationInhibit
type BACnetConstructedDataReliabilityEvaluationInhibit interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetReliabilityEvaluationInhibit returns ReliabilityEvaluationInhibit (property field)
	GetReliabilityEvaluationInhibit() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataReliabilityEvaluationInhibit is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataReliabilityEvaluationInhibit()
	// CreateBuilder creates a BACnetConstructedDataReliabilityEvaluationInhibitBuilder
	CreateBACnetConstructedDataReliabilityEvaluationInhibitBuilder() BACnetConstructedDataReliabilityEvaluationInhibitBuilder
}

// _BACnetConstructedDataReliabilityEvaluationInhibit is the data-structure of this message
type _BACnetConstructedDataReliabilityEvaluationInhibit struct {
	BACnetConstructedDataContract
	ReliabilityEvaluationInhibit BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataReliabilityEvaluationInhibit = (*_BACnetConstructedDataReliabilityEvaluationInhibit)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataReliabilityEvaluationInhibit)(nil)

// NewBACnetConstructedDataReliabilityEvaluationInhibit factory function for _BACnetConstructedDataReliabilityEvaluationInhibit
func NewBACnetConstructedDataReliabilityEvaluationInhibit(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, reliabilityEvaluationInhibit BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataReliabilityEvaluationInhibit {
	if reliabilityEvaluationInhibit == nil {
		panic("reliabilityEvaluationInhibit of type BACnetApplicationTagBoolean for BACnetConstructedDataReliabilityEvaluationInhibit must not be nil")
	}
	_result := &_BACnetConstructedDataReliabilityEvaluationInhibit{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ReliabilityEvaluationInhibit:  reliabilityEvaluationInhibit,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataReliabilityEvaluationInhibitBuilder is a builder for BACnetConstructedDataReliabilityEvaluationInhibit
type BACnetConstructedDataReliabilityEvaluationInhibitBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(reliabilityEvaluationInhibit BACnetApplicationTagBoolean) BACnetConstructedDataReliabilityEvaluationInhibitBuilder
	// WithReliabilityEvaluationInhibit adds ReliabilityEvaluationInhibit (property field)
	WithReliabilityEvaluationInhibit(BACnetApplicationTagBoolean) BACnetConstructedDataReliabilityEvaluationInhibitBuilder
	// WithReliabilityEvaluationInhibitBuilder adds ReliabilityEvaluationInhibit (property field) which is build by the builder
	WithReliabilityEvaluationInhibitBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataReliabilityEvaluationInhibitBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataReliabilityEvaluationInhibit or returns an error if something is wrong
	Build() (BACnetConstructedDataReliabilityEvaluationInhibit, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataReliabilityEvaluationInhibit
}

// NewBACnetConstructedDataReliabilityEvaluationInhibitBuilder() creates a BACnetConstructedDataReliabilityEvaluationInhibitBuilder
func NewBACnetConstructedDataReliabilityEvaluationInhibitBuilder() BACnetConstructedDataReliabilityEvaluationInhibitBuilder {
	return &_BACnetConstructedDataReliabilityEvaluationInhibitBuilder{_BACnetConstructedDataReliabilityEvaluationInhibit: new(_BACnetConstructedDataReliabilityEvaluationInhibit)}
}

type _BACnetConstructedDataReliabilityEvaluationInhibitBuilder struct {
	*_BACnetConstructedDataReliabilityEvaluationInhibit

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataReliabilityEvaluationInhibitBuilder) = (*_BACnetConstructedDataReliabilityEvaluationInhibitBuilder)(nil)

func (b *_BACnetConstructedDataReliabilityEvaluationInhibitBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataReliabilityEvaluationInhibit
}

func (b *_BACnetConstructedDataReliabilityEvaluationInhibitBuilder) WithMandatoryFields(reliabilityEvaluationInhibit BACnetApplicationTagBoolean) BACnetConstructedDataReliabilityEvaluationInhibitBuilder {
	return b.WithReliabilityEvaluationInhibit(reliabilityEvaluationInhibit)
}

func (b *_BACnetConstructedDataReliabilityEvaluationInhibitBuilder) WithReliabilityEvaluationInhibit(reliabilityEvaluationInhibit BACnetApplicationTagBoolean) BACnetConstructedDataReliabilityEvaluationInhibitBuilder {
	b.ReliabilityEvaluationInhibit = reliabilityEvaluationInhibit
	return b
}

func (b *_BACnetConstructedDataReliabilityEvaluationInhibitBuilder) WithReliabilityEvaluationInhibitBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataReliabilityEvaluationInhibitBuilder {
	builder := builderSupplier(b.ReliabilityEvaluationInhibit.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.ReliabilityEvaluationInhibit, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataReliabilityEvaluationInhibitBuilder) Build() (BACnetConstructedDataReliabilityEvaluationInhibit, error) {
	if b.ReliabilityEvaluationInhibit == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'reliabilityEvaluationInhibit' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataReliabilityEvaluationInhibit.deepCopy(), nil
}

func (b *_BACnetConstructedDataReliabilityEvaluationInhibitBuilder) MustBuild() BACnetConstructedDataReliabilityEvaluationInhibit {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataReliabilityEvaluationInhibitBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataReliabilityEvaluationInhibitBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataReliabilityEvaluationInhibitBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataReliabilityEvaluationInhibitBuilder().(*_BACnetConstructedDataReliabilityEvaluationInhibitBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataReliabilityEvaluationInhibitBuilder creates a BACnetConstructedDataReliabilityEvaluationInhibitBuilder
func (b *_BACnetConstructedDataReliabilityEvaluationInhibit) CreateBACnetConstructedDataReliabilityEvaluationInhibitBuilder() BACnetConstructedDataReliabilityEvaluationInhibitBuilder {
	if b == nil {
		return NewBACnetConstructedDataReliabilityEvaluationInhibitBuilder()
	}
	return &_BACnetConstructedDataReliabilityEvaluationInhibitBuilder{_BACnetConstructedDataReliabilityEvaluationInhibit: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_RELIABILITY_EVALUATION_INHIBIT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) GetReliabilityEvaluationInhibit() BACnetApplicationTagBoolean {
	return m.ReliabilityEvaluationInhibit
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetReliabilityEvaluationInhibit())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataReliabilityEvaluationInhibit(structType any) BACnetConstructedDataReliabilityEvaluationInhibit {
	if casted, ok := structType.(BACnetConstructedDataReliabilityEvaluationInhibit); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataReliabilityEvaluationInhibit); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) GetTypeName() string {
	return "BACnetConstructedDataReliabilityEvaluationInhibit"
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (reliabilityEvaluationInhibit)
	lengthInBits += m.ReliabilityEvaluationInhibit.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataReliabilityEvaluationInhibit BACnetConstructedDataReliabilityEvaluationInhibit, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataReliabilityEvaluationInhibit"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataReliabilityEvaluationInhibit")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reliabilityEvaluationInhibit, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "reliabilityEvaluationInhibit", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'reliabilityEvaluationInhibit' field"))
	}
	m.ReliabilityEvaluationInhibit = reliabilityEvaluationInhibit

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), reliabilityEvaluationInhibit)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataReliabilityEvaluationInhibit"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataReliabilityEvaluationInhibit")
	}

	return m, nil
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataReliabilityEvaluationInhibit"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataReliabilityEvaluationInhibit")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "reliabilityEvaluationInhibit", m.GetReliabilityEvaluationInhibit(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'reliabilityEvaluationInhibit' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataReliabilityEvaluationInhibit"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataReliabilityEvaluationInhibit")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) IsBACnetConstructedDataReliabilityEvaluationInhibit() {
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) deepCopy() *_BACnetConstructedDataReliabilityEvaluationInhibit {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataReliabilityEvaluationInhibitCopy := &_BACnetConstructedDataReliabilityEvaluationInhibit{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.ReliabilityEvaluationInhibit),
	}
	_BACnetConstructedDataReliabilityEvaluationInhibitCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataReliabilityEvaluationInhibitCopy
}

func (m *_BACnetConstructedDataReliabilityEvaluationInhibit) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
