/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEventStateTagged is the corresponding interface of BACnetEventStateTagged
type BACnetEventStateTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetEventState
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetEventStateTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetEventStateTagged()
	// CreateBuilder creates a BACnetEventStateTaggedBuilder
	CreateBACnetEventStateTaggedBuilder() BACnetEventStateTaggedBuilder
}

// _BACnetEventStateTagged is the data-structure of this message
type _BACnetEventStateTagged struct {
	Header           BACnetTagHeader
	Value            BACnetEventState
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetEventStateTagged = (*_BACnetEventStateTagged)(nil)

// NewBACnetEventStateTagged factory function for _BACnetEventStateTagged
func NewBACnetEventStateTagged(header BACnetTagHeader, value BACnetEventState, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetEventStateTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetEventStateTagged must not be nil")
	}
	return &_BACnetEventStateTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetEventStateTaggedBuilder is a builder for BACnetEventStateTagged
type BACnetEventStateTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetEventState, proprietaryValue uint32) BACnetEventStateTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetEventStateTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEventStateTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetEventState) BACnetEventStateTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetEventStateTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetEventStateTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetEventStateTaggedBuilder
	// Build builds the BACnetEventStateTagged or returns an error if something is wrong
	Build() (BACnetEventStateTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetEventStateTagged
}

// NewBACnetEventStateTaggedBuilder() creates a BACnetEventStateTaggedBuilder
func NewBACnetEventStateTaggedBuilder() BACnetEventStateTaggedBuilder {
	return &_BACnetEventStateTaggedBuilder{_BACnetEventStateTagged: new(_BACnetEventStateTagged)}
}

type _BACnetEventStateTaggedBuilder struct {
	*_BACnetEventStateTagged

	collectedErr []error
}

var _ (BACnetEventStateTaggedBuilder) = (*_BACnetEventStateTaggedBuilder)(nil)

func (b *_BACnetEventStateTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetEventState, proprietaryValue uint32) BACnetEventStateTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetEventStateTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetEventStateTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetEventStateTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetEventStateTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetEventStateTaggedBuilder) WithValue(value BACnetEventState) BACnetEventStateTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetEventStateTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetEventStateTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetEventStateTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetEventStateTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetEventStateTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetEventStateTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetEventStateTaggedBuilder) Build() (BACnetEventStateTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetEventStateTagged.deepCopy(), nil
}

func (b *_BACnetEventStateTaggedBuilder) MustBuild() BACnetEventStateTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetEventStateTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetEventStateTaggedBuilder().(*_BACnetEventStateTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetEventStateTaggedBuilder creates a BACnetEventStateTaggedBuilder
func (b *_BACnetEventStateTagged) CreateBACnetEventStateTaggedBuilder() BACnetEventStateTaggedBuilder {
	if b == nil {
		return NewBACnetEventStateTaggedBuilder()
	}
	return &_BACnetEventStateTaggedBuilder{_BACnetEventStateTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetEventStateTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetEventStateTagged) GetValue() BACnetEventState {
	return m.Value
}

func (m *_BACnetEventStateTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetEventStateTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetEventState_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetEventStateTagged(structType any) BACnetEventStateTagged {
	if casted, ok := structType.(BACnetEventStateTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetEventStateTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetEventStateTagged) GetTypeName() string {
	return "BACnetEventStateTagged"
}

func (m *_BACnetEventStateTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetEventStateTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetEventStateTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetEventStateTagged, error) {
	return BACnetEventStateTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetEventStateTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventStateTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetEventStateTagged, error) {
		return BACnetEventStateTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetEventStateTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetEventStateTagged, error) {
	v, err := (&_BACnetEventStateTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetEventStateTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetEventStateTagged BACnetEventStateTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetEventStateTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetEventStateTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetEventState](ctx, "value", readBuffer, EnsureType[BACnetEventState](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetEventState_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetEventState_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetEventStateTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetEventStateTagged")
	}

	return m, nil
}

func (m *_BACnetEventStateTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetEventStateTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetEventStateTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetEventStateTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetEventState](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetEventStateTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetEventStateTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetEventStateTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetEventStateTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetEventStateTagged) IsBACnetEventStateTagged() {}

func (m *_BACnetEventStateTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetEventStateTagged) deepCopy() *_BACnetEventStateTagged {
	if m == nil {
		return nil
	}
	_BACnetEventStateTaggedCopy := &_BACnetEventStateTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetEventStateTaggedCopy
}

func (m *_BACnetEventStateTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
