/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ConnectionTransportDataType is the corresponding interface of ConnectionTransportDataType
type ConnectionTransportDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// IsConnectionTransportDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsConnectionTransportDataType()
	// CreateBuilder creates a ConnectionTransportDataTypeBuilder
	CreateConnectionTransportDataTypeBuilder() ConnectionTransportDataTypeBuilder
}

// _ConnectionTransportDataType is the data-structure of this message
type _ConnectionTransportDataType struct {
	ExtensionObjectDefinitionContract
}

var _ ConnectionTransportDataType = (*_ConnectionTransportDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ConnectionTransportDataType)(nil)

// NewConnectionTransportDataType factory function for _ConnectionTransportDataType
func NewConnectionTransportDataType() *_ConnectionTransportDataType {
	_result := &_ConnectionTransportDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ConnectionTransportDataTypeBuilder is a builder for ConnectionTransportDataType
type ConnectionTransportDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ConnectionTransportDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ConnectionTransportDataType or returns an error if something is wrong
	Build() (ConnectionTransportDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ConnectionTransportDataType
}

// NewConnectionTransportDataTypeBuilder() creates a ConnectionTransportDataTypeBuilder
func NewConnectionTransportDataTypeBuilder() ConnectionTransportDataTypeBuilder {
	return &_ConnectionTransportDataTypeBuilder{_ConnectionTransportDataType: new(_ConnectionTransportDataType)}
}

type _ConnectionTransportDataTypeBuilder struct {
	*_ConnectionTransportDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ConnectionTransportDataTypeBuilder) = (*_ConnectionTransportDataTypeBuilder)(nil)

func (b *_ConnectionTransportDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ConnectionTransportDataType
}

func (b *_ConnectionTransportDataTypeBuilder) WithMandatoryFields() ConnectionTransportDataTypeBuilder {
	return b
}

func (b *_ConnectionTransportDataTypeBuilder) Build() (ConnectionTransportDataType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ConnectionTransportDataType.deepCopy(), nil
}

func (b *_ConnectionTransportDataTypeBuilder) MustBuild() ConnectionTransportDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ConnectionTransportDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ConnectionTransportDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ConnectionTransportDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateConnectionTransportDataTypeBuilder().(*_ConnectionTransportDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateConnectionTransportDataTypeBuilder creates a ConnectionTransportDataTypeBuilder
func (b *_ConnectionTransportDataType) CreateConnectionTransportDataTypeBuilder() ConnectionTransportDataTypeBuilder {
	if b == nil {
		return NewConnectionTransportDataTypeBuilder()
	}
	return &_ConnectionTransportDataTypeBuilder{_ConnectionTransportDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ConnectionTransportDataType) GetExtensionId() int32 {
	return int32(15620)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ConnectionTransportDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

// Deprecated: use the interface for direct cast
func CastConnectionTransportDataType(structType any) ConnectionTransportDataType {
	if casted, ok := structType.(ConnectionTransportDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ConnectionTransportDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ConnectionTransportDataType) GetTypeName() string {
	return "ConnectionTransportDataType"
}

func (m *_ConnectionTransportDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ConnectionTransportDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ConnectionTransportDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__connectionTransportDataType ConnectionTransportDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ConnectionTransportDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ConnectionTransportDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ConnectionTransportDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ConnectionTransportDataType")
	}

	return m, nil
}

func (m *_ConnectionTransportDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ConnectionTransportDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ConnectionTransportDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ConnectionTransportDataType")
		}

		if popErr := writeBuffer.PopContext("ConnectionTransportDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ConnectionTransportDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ConnectionTransportDataType) IsConnectionTransportDataType() {}

func (m *_ConnectionTransportDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ConnectionTransportDataType) deepCopy() *_ConnectionTransportDataType {
	if m == nil {
		return nil
	}
	_ConnectionTransportDataTypeCopy := &_ConnectionTransportDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
	}
	_ConnectionTransportDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ConnectionTransportDataTypeCopy
}

func (m *_ConnectionTransportDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
