/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MonitoredItemCreateRequest is the corresponding interface of MonitoredItemCreateRequest
type MonitoredItemCreateRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetItemToMonitor returns ItemToMonitor (property field)
	GetItemToMonitor() ReadValueId
	// GetMonitoringMode returns MonitoringMode (property field)
	GetMonitoringMode() MonitoringMode
	// GetRequestedParameters returns RequestedParameters (property field)
	GetRequestedParameters() MonitoringParameters
	// IsMonitoredItemCreateRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMonitoredItemCreateRequest()
	// CreateBuilder creates a MonitoredItemCreateRequestBuilder
	CreateMonitoredItemCreateRequestBuilder() MonitoredItemCreateRequestBuilder
}

// _MonitoredItemCreateRequest is the data-structure of this message
type _MonitoredItemCreateRequest struct {
	ExtensionObjectDefinitionContract
	ItemToMonitor       ReadValueId
	MonitoringMode      MonitoringMode
	RequestedParameters MonitoringParameters
}

var _ MonitoredItemCreateRequest = (*_MonitoredItemCreateRequest)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_MonitoredItemCreateRequest)(nil)

// NewMonitoredItemCreateRequest factory function for _MonitoredItemCreateRequest
func NewMonitoredItemCreateRequest(itemToMonitor ReadValueId, monitoringMode MonitoringMode, requestedParameters MonitoringParameters) *_MonitoredItemCreateRequest {
	if itemToMonitor == nil {
		panic("itemToMonitor of type ReadValueId for MonitoredItemCreateRequest must not be nil")
	}
	if requestedParameters == nil {
		panic("requestedParameters of type MonitoringParameters for MonitoredItemCreateRequest must not be nil")
	}
	_result := &_MonitoredItemCreateRequest{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ItemToMonitor:                     itemToMonitor,
		MonitoringMode:                    monitoringMode,
		RequestedParameters:               requestedParameters,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MonitoredItemCreateRequestBuilder is a builder for MonitoredItemCreateRequest
type MonitoredItemCreateRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(itemToMonitor ReadValueId, monitoringMode MonitoringMode, requestedParameters MonitoringParameters) MonitoredItemCreateRequestBuilder
	// WithItemToMonitor adds ItemToMonitor (property field)
	WithItemToMonitor(ReadValueId) MonitoredItemCreateRequestBuilder
	// WithItemToMonitorBuilder adds ItemToMonitor (property field) which is build by the builder
	WithItemToMonitorBuilder(func(ReadValueIdBuilder) ReadValueIdBuilder) MonitoredItemCreateRequestBuilder
	// WithMonitoringMode adds MonitoringMode (property field)
	WithMonitoringMode(MonitoringMode) MonitoredItemCreateRequestBuilder
	// WithRequestedParameters adds RequestedParameters (property field)
	WithRequestedParameters(MonitoringParameters) MonitoredItemCreateRequestBuilder
	// WithRequestedParametersBuilder adds RequestedParameters (property field) which is build by the builder
	WithRequestedParametersBuilder(func(MonitoringParametersBuilder) MonitoringParametersBuilder) MonitoredItemCreateRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the MonitoredItemCreateRequest or returns an error if something is wrong
	Build() (MonitoredItemCreateRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MonitoredItemCreateRequest
}

// NewMonitoredItemCreateRequestBuilder() creates a MonitoredItemCreateRequestBuilder
func NewMonitoredItemCreateRequestBuilder() MonitoredItemCreateRequestBuilder {
	return &_MonitoredItemCreateRequestBuilder{_MonitoredItemCreateRequest: new(_MonitoredItemCreateRequest)}
}

type _MonitoredItemCreateRequestBuilder struct {
	*_MonitoredItemCreateRequest

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (MonitoredItemCreateRequestBuilder) = (*_MonitoredItemCreateRequestBuilder)(nil)

func (b *_MonitoredItemCreateRequestBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._MonitoredItemCreateRequest
}

func (b *_MonitoredItemCreateRequestBuilder) WithMandatoryFields(itemToMonitor ReadValueId, monitoringMode MonitoringMode, requestedParameters MonitoringParameters) MonitoredItemCreateRequestBuilder {
	return b.WithItemToMonitor(itemToMonitor).WithMonitoringMode(monitoringMode).WithRequestedParameters(requestedParameters)
}

func (b *_MonitoredItemCreateRequestBuilder) WithItemToMonitor(itemToMonitor ReadValueId) MonitoredItemCreateRequestBuilder {
	b.ItemToMonitor = itemToMonitor
	return b
}

func (b *_MonitoredItemCreateRequestBuilder) WithItemToMonitorBuilder(builderSupplier func(ReadValueIdBuilder) ReadValueIdBuilder) MonitoredItemCreateRequestBuilder {
	builder := builderSupplier(b.ItemToMonitor.CreateReadValueIdBuilder())
	var err error
	b.ItemToMonitor, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ReadValueIdBuilder failed"))
	}
	return b
}

func (b *_MonitoredItemCreateRequestBuilder) WithMonitoringMode(monitoringMode MonitoringMode) MonitoredItemCreateRequestBuilder {
	b.MonitoringMode = monitoringMode
	return b
}

func (b *_MonitoredItemCreateRequestBuilder) WithRequestedParameters(requestedParameters MonitoringParameters) MonitoredItemCreateRequestBuilder {
	b.RequestedParameters = requestedParameters
	return b
}

func (b *_MonitoredItemCreateRequestBuilder) WithRequestedParametersBuilder(builderSupplier func(MonitoringParametersBuilder) MonitoringParametersBuilder) MonitoredItemCreateRequestBuilder {
	builder := builderSupplier(b.RequestedParameters.CreateMonitoringParametersBuilder())
	var err error
	b.RequestedParameters, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "MonitoringParametersBuilder failed"))
	}
	return b
}

func (b *_MonitoredItemCreateRequestBuilder) Build() (MonitoredItemCreateRequest, error) {
	if b.ItemToMonitor == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'itemToMonitor' not set"))
	}
	if b.RequestedParameters == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'requestedParameters' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._MonitoredItemCreateRequest.deepCopy(), nil
}

func (b *_MonitoredItemCreateRequestBuilder) MustBuild() MonitoredItemCreateRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MonitoredItemCreateRequestBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_MonitoredItemCreateRequestBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_MonitoredItemCreateRequestBuilder) DeepCopy() any {
	_copy := b.CreateMonitoredItemCreateRequestBuilder().(*_MonitoredItemCreateRequestBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateMonitoredItemCreateRequestBuilder creates a MonitoredItemCreateRequestBuilder
func (b *_MonitoredItemCreateRequest) CreateMonitoredItemCreateRequestBuilder() MonitoredItemCreateRequestBuilder {
	if b == nil {
		return NewMonitoredItemCreateRequestBuilder()
	}
	return &_MonitoredItemCreateRequestBuilder{_MonitoredItemCreateRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_MonitoredItemCreateRequest) GetExtensionId() int32 {
	return int32(745)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MonitoredItemCreateRequest) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MonitoredItemCreateRequest) GetItemToMonitor() ReadValueId {
	return m.ItemToMonitor
}

func (m *_MonitoredItemCreateRequest) GetMonitoringMode() MonitoringMode {
	return m.MonitoringMode
}

func (m *_MonitoredItemCreateRequest) GetRequestedParameters() MonitoringParameters {
	return m.RequestedParameters
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMonitoredItemCreateRequest(structType any) MonitoredItemCreateRequest {
	if casted, ok := structType.(MonitoredItemCreateRequest); ok {
		return casted
	}
	if casted, ok := structType.(*MonitoredItemCreateRequest); ok {
		return *casted
	}
	return nil
}

func (m *_MonitoredItemCreateRequest) GetTypeName() string {
	return "MonitoredItemCreateRequest"
}

func (m *_MonitoredItemCreateRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (itemToMonitor)
	lengthInBits += m.ItemToMonitor.GetLengthInBits(ctx)

	// Simple field (monitoringMode)
	lengthInBits += 32

	// Simple field (requestedParameters)
	lengthInBits += m.RequestedParameters.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_MonitoredItemCreateRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MonitoredItemCreateRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__monitoredItemCreateRequest MonitoredItemCreateRequest, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MonitoredItemCreateRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MonitoredItemCreateRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	itemToMonitor, err := ReadSimpleField[ReadValueId](ctx, "itemToMonitor", ReadComplex[ReadValueId](ExtensionObjectDefinitionParseWithBufferProducer[ReadValueId]((int32)(int32(628))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'itemToMonitor' field"))
	}
	m.ItemToMonitor = itemToMonitor

	monitoringMode, err := ReadEnumField[MonitoringMode](ctx, "monitoringMode", "MonitoringMode", ReadEnum(MonitoringModeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'monitoringMode' field"))
	}
	m.MonitoringMode = monitoringMode

	requestedParameters, err := ReadSimpleField[MonitoringParameters](ctx, "requestedParameters", ReadComplex[MonitoringParameters](ExtensionObjectDefinitionParseWithBufferProducer[MonitoringParameters]((int32)(int32(742))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestedParameters' field"))
	}
	m.RequestedParameters = requestedParameters

	if closeErr := readBuffer.CloseContext("MonitoredItemCreateRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MonitoredItemCreateRequest")
	}

	return m, nil
}

func (m *_MonitoredItemCreateRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MonitoredItemCreateRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MonitoredItemCreateRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MonitoredItemCreateRequest")
		}

		if err := WriteSimpleField[ReadValueId](ctx, "itemToMonitor", m.GetItemToMonitor(), WriteComplex[ReadValueId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'itemToMonitor' field")
		}

		if err := WriteSimpleEnumField[MonitoringMode](ctx, "monitoringMode", "MonitoringMode", m.GetMonitoringMode(), WriteEnum[MonitoringMode, uint32](MonitoringMode.GetValue, MonitoringMode.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'monitoringMode' field")
		}

		if err := WriteSimpleField[MonitoringParameters](ctx, "requestedParameters", m.GetRequestedParameters(), WriteComplex[MonitoringParameters](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestedParameters' field")
		}

		if popErr := writeBuffer.PopContext("MonitoredItemCreateRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MonitoredItemCreateRequest")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MonitoredItemCreateRequest) IsMonitoredItemCreateRequest() {}

func (m *_MonitoredItemCreateRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MonitoredItemCreateRequest) deepCopy() *_MonitoredItemCreateRequest {
	if m == nil {
		return nil
	}
	_MonitoredItemCreateRequestCopy := &_MonitoredItemCreateRequest{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[ReadValueId](m.ItemToMonitor),
		m.MonitoringMode,
		utils.DeepCopy[MonitoringParameters](m.RequestedParameters),
	}
	_MonitoredItemCreateRequestCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _MonitoredItemCreateRequestCopy
}

func (m *_MonitoredItemCreateRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
