/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BVLCReadBroadcastDistributionTableAck extends BVLC implements Message {

  // Accessors for discriminator values.
  public Short getBvlcFunction() {
    return (short) 0x03;
  }

  // Properties.
  protected final List<BVLCBroadcastDistributionTableEntry> table;

  // Arguments.
  protected final Integer bvlcPayloadLength;

  public BVLCReadBroadcastDistributionTableAck(
      List<BVLCBroadcastDistributionTableEntry> table, Integer bvlcPayloadLength) {
    super();
    this.table = table;
    this.bvlcPayloadLength = bvlcPayloadLength;
  }

  public List<BVLCBroadcastDistributionTableEntry> getTable() {
    return table;
  }

  @Override
  protected void serializeBVLCChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BVLCReadBroadcastDistributionTableAck");

    // Array Field (table)
    writeComplexTypeArrayField(
        "table", table, writeBuffer, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("BVLCReadBroadcastDistributionTableAck");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BVLCReadBroadcastDistributionTableAck _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Array field
    if (table != null) {
      for (Message element : table) {
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static BVLCBuilder staticParseBVLCBuilder(ReadBuffer readBuffer, Integer bvlcPayloadLength)
      throws ParseException {
    readBuffer.pullContext("BVLCReadBroadcastDistributionTableAck");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    List<BVLCBroadcastDistributionTableEntry> table =
        readLengthArrayField(
            "table",
            readComplex(
                () -> BVLCBroadcastDistributionTableEntry.staticParse(readBuffer), readBuffer),
            bvlcPayloadLength,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("BVLCReadBroadcastDistributionTableAck");
    // Create the instance
    return new BVLCReadBroadcastDistributionTableAckBuilderImpl(table, bvlcPayloadLength);
  }

  public static class BVLCReadBroadcastDistributionTableAckBuilderImpl implements BVLC.BVLCBuilder {
    private final List<BVLCBroadcastDistributionTableEntry> table;
    private final Integer bvlcPayloadLength;

    public BVLCReadBroadcastDistributionTableAckBuilderImpl(
        List<BVLCBroadcastDistributionTableEntry> table, Integer bvlcPayloadLength) {
      this.table = table;
      this.bvlcPayloadLength = bvlcPayloadLength;
    }

    public BVLCReadBroadcastDistributionTableAck build() {
      BVLCReadBroadcastDistributionTableAck bVLCReadBroadcastDistributionTableAck =
          new BVLCReadBroadcastDistributionTableAck(table, bvlcPayloadLength);
      return bVLCReadBroadcastDistributionTableAck;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BVLCReadBroadcastDistributionTableAck)) {
      return false;
    }
    BVLCReadBroadcastDistributionTableAck that = (BVLCReadBroadcastDistributionTableAck) o;
    return (getTable() == that.getTable()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTable());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
