/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AnnotationDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 32436;
  }

  // Properties.
  protected final PascalString annotation;
  protected final PascalString discipline;
  protected final PascalString uri;

  public AnnotationDataType(PascalString annotation, PascalString discipline, PascalString uri) {
    super();
    this.annotation = annotation;
    this.discipline = discipline;
    this.uri = uri;
  }

  public PascalString getAnnotation() {
    return annotation;
  }

  public PascalString getDiscipline() {
    return discipline;
  }

  public PascalString getUri() {
    return uri;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AnnotationDataType");

    // Simple Field (annotation)
    writeSimpleField("annotation", annotation, writeComplex(writeBuffer));

    // Simple Field (discipline)
    writeSimpleField("discipline", discipline, writeComplex(writeBuffer));

    // Simple Field (uri)
    writeSimpleField("uri", uri, writeComplex(writeBuffer));

    writeBuffer.popContext("AnnotationDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AnnotationDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (annotation)
    lengthInBits += annotation.getLengthInBits();

    // Simple field (discipline)
    lengthInBits += discipline.getLengthInBits();

    // Simple field (uri)
    lengthInBits += uri.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("AnnotationDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString annotation =
        readSimpleField(
            "annotation", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString discipline =
        readSimpleField(
            "discipline", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString uri =
        readSimpleField("uri", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("AnnotationDataType");
    // Create the instance
    return new AnnotationDataTypeBuilderImpl(annotation, discipline, uri);
  }

  public static class AnnotationDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString annotation;
    private final PascalString discipline;
    private final PascalString uri;

    public AnnotationDataTypeBuilderImpl(
        PascalString annotation, PascalString discipline, PascalString uri) {
      this.annotation = annotation;
      this.discipline = discipline;
      this.uri = uri;
    }

    public AnnotationDataType build() {
      AnnotationDataType annotationDataType = new AnnotationDataType(annotation, discipline, uri);
      return annotationDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AnnotationDataType)) {
      return false;
    }
    AnnotationDataType that = (AnnotationDataType) o;
    return (getAnnotation() == that.getAnnotation())
        && (getDiscipline() == that.getDiscipline())
        && (getUri() == that.getUri())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getAnnotation(), getDiscipline(), getUri());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
