/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2.protocol;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.Metadata;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.MetadataResolver;
import org.apache.pulsar.common.util.ObjectMapperFactory;

public class DefaultMetadataResolver
implements MetadataResolver {
    protected static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 10;
    protected static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 30;
    private final URL metadataUrl;
    private final ObjectReader objectReader;
    private Duration connectTimeout;
    private Duration readTimeout;

    public DefaultMetadataResolver(URL metadataUrl) {
        this.metadataUrl = metadataUrl;
        this.objectReader = ObjectMapperFactory.getMapper().reader().forType(Metadata.class);
        this.connectTimeout = Duration.ofSeconds(10L);
        this.readTimeout = Duration.ofSeconds(30L);
    }

    public DefaultMetadataResolver withConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public DefaultMetadataResolver withReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public Metadata resolve() throws IOException {
        try {
            Metadata metadata;
            URLConnection c = this.metadataUrl.openConnection();
            if (this.connectTimeout != null) {
                c.setConnectTimeout((int)this.connectTimeout.toMillis());
            }
            if (this.readTimeout != null) {
                c.setReadTimeout((int)this.readTimeout.toMillis());
            }
            c.setRequestProperty("Accept", "application/json");
            try (InputStream inputStream = c.getInputStream();){
                metadata = (Metadata)this.objectReader.readValue(inputStream);
            }
            return metadata;
        }
        catch (IOException e) {
            throw new IOException("Cannot obtain authorization metadata from " + this.metadataUrl.toString(), e);
        }
    }

    public static DefaultMetadataResolver fromIssuerUrl(URL issuerUrl) {
        return new DefaultMetadataResolver(DefaultMetadataResolver.getWellKnownMetadataUrl(issuerUrl));
    }

    public static URL getWellKnownMetadataUrl(URL issuerUrl) {
        try {
            return URI.create(issuerUrl.toExternalForm() + "/.well-known/openid-configuration").normalize().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

