/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.Status;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.exception.BadRequestException;
import org.apache.rocketmq.client.java.exception.TooManyRequestsException;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.impl.consumer.ConsumeService;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.impl.consumer.PushConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.PushConsumerSettings;
import org.apache.rocketmq.client.java.impl.consumer.ReceiveMessageResult;
import org.apache.rocketmq.client.java.message.MessageCommon;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.retry.RetryPolicy;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.rpc.RpcInvocation;
import org.apache.rocketmq.shaded.com.google.common.base.Stopwatch;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.rocketmq.shaded.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

class ProcessQueueImpl
implements ProcessQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessQueueImpl.class);
    private static final Duration FORWARD_FIFO_MESSAGE_TO_DLQ_FAILURE_BACKOFF_DELAY = Duration.ofSeconds(1L);
    private static final Duration ACK_MESSAGE_FAILURE_BACKOFF_DELAY = Duration.ofSeconds(1L);
    private static final Duration CHANGE_INVISIBLE_DURATION_FAILURE_BACKOFF_DELAY = Duration.ofSeconds(1L);
    private static final Duration RECEIVING_FLOW_CONTROL_BACKOFF_DELAY = Duration.ofMillis(20L);
    private static final Duration RECEIVING_FAILURE_BACKOFF_DELAY = Duration.ofSeconds(1L);
    private static final Duration RECEIVING_BACKOFF_DELAY_WHEN_CACHE_IS_FULL = Duration.ofSeconds(1L);
    private final PushConsumerImpl consumer;
    private volatile boolean dropped;
    private final MessageQueueImpl mq;
    private final FilterExpression filterExpression;
    @GuardedBy(value="pendingMessagesLock")
    private final List<MessageViewImpl> pendingMessages;
    private final ReadWriteLock pendingMessagesLock;
    @GuardedBy(value="inflightMessagesLock")
    private final List<MessageViewImpl> inflightMessages;
    private final ReadWriteLock inflightMessagesLock;
    private final AtomicLong cachedMessagesBytes;
    private final AtomicLong receptionTimes;
    private final AtomicLong receivedMessagesQuantity;
    private volatile long activityNanoTime = System.nanoTime();

    public ProcessQueueImpl(PushConsumerImpl consumer, MessageQueueImpl mq, FilterExpression filterExpression) {
        this.consumer = consumer;
        this.dropped = false;
        this.mq = mq;
        this.filterExpression = filterExpression;
        this.pendingMessages = new ArrayList<MessageViewImpl>();
        this.pendingMessagesLock = new ReentrantReadWriteLock();
        this.inflightMessages = new ArrayList<MessageViewImpl>();
        this.inflightMessagesLock = new ReentrantReadWriteLock();
        this.cachedMessagesBytes = new AtomicLong();
        this.receptionTimes = new AtomicLong(0L);
        this.receivedMessagesQuantity = new AtomicLong(0L);
    }

    @Override
    public MessageQueueImpl getMessageQueue() {
        return this.mq;
    }

    @Override
    public void drop() {
        this.dropped = true;
    }

    @Override
    public boolean expired() {
        PushConsumerSettings settings = this.consumer.getPushConsumerSettings();
        Duration maxIdleDuration = Duration.ofNanos(2L * (settings.getLongPollingTimeout().toNanos() + this.consumer.getClientConfiguration().getRequestTimeout().toNanos()));
        Duration idleDuration = Duration.ofNanos(System.nanoTime() - this.activityNanoTime);
        if (idleDuration.compareTo(maxIdleDuration) < 0) {
            return false;
        }
        LOGGER.warn("Process queue is idle, idleDuration={}, maxIdleDuration={}, mq={}, clientId={}", idleDuration, maxIdleDuration, this.mq, this.consumer.clientId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheMessages(List<MessageViewImpl> messageList) {
        ArrayList<MessageViewImpl> corrupted = new ArrayList<MessageViewImpl>();
        this.pendingMessagesLock.writeLock().lock();
        try {
            MessageViewImpl previous = null;
            for (MessageViewImpl messageView2 : messageList) {
                if (messageView2.isCorrupted()) {
                    corrupted.add(messageView2);
                    continue;
                }
                if (null != previous) {
                    previous.setNext(messageView2);
                }
                previous = messageView2;
                this.pendingMessages.add(messageView2);
                this.cachedMessagesBytes.addAndGet(messageView2.getBody().remaining());
            }
        }
        finally {
            this.pendingMessagesLock.writeLock().unlock();
            corrupted.forEach(messageView -> {
                MessageId messageId = messageView.getMessageId();
                if (this.consumer.getPushConsumerSettings().isFifo()) {
                    LOGGER.error("Message is corrupted, forward it to dead letter queue in fifo mode, mq={}, messageId={}, clientId={}", this.mq, messageId, this.consumer.clientId());
                    this.forwardToDeadLetterQueue((MessageViewImpl)messageView);
                    return;
                }
                LOGGER.error("Message is corrupted, nack it in standard mode, mq={}, messageId={}, clientId={}", this.mq, messageId, this.consumer.clientId());
                this.nackMessage((MessageViewImpl)messageView);
            });
        }
    }

    private int getReceptionBatchSize() {
        int bufferSize = this.consumer.cacheMessageCountThresholdPerQueue() - this.cachedMessagesCount();
        bufferSize = Math.max(bufferSize, 1);
        return Math.min(bufferSize, this.consumer.getPushConsumerSettings().getReceiveBatchSize());
    }

    @Override
    public void fetchMessageImmediately() {
        this.receiveMessageImmediately();
    }

    public void onReceiveMessageException(Throwable t) {
        Duration delay = t instanceof TooManyRequestsException ? RECEIVING_FLOW_CONTROL_BACKOFF_DELAY : RECEIVING_FAILURE_BACKOFF_DELAY;
        this.receiveMessageLater(delay);
    }

    private void receiveMessageLater(Duration delay) {
        String clientId = this.consumer.clientId();
        ScheduledExecutorService scheduler = this.consumer.getScheduler();
        try {
            LOGGER.info("Try to receive message later, mq={}, delay={}, clientId={}", this.mq, delay, clientId);
            scheduler.schedule(this::receiveMessage, delay.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            if (scheduler.isShutdown()) {
                return;
            }
            LOGGER.error("[Bug] Failed to schedule message receiving request, mq={}, clientId={}", this.mq, clientId, t);
            this.onReceiveMessageException(t);
        }
    }

    public void receiveMessage() {
        if (this.dropped) {
            LOGGER.info("Process queue has been dropped, no longer receive message, mq={}, clientId={}", (Object)this.mq, (Object)this.consumer.clientId());
            return;
        }
        if (this.isCacheFull()) {
            LOGGER.warn("Process queue cache is full, would receive message later, mq={}, clientId={}", (Object)this.mq, (Object)this.consumer.clientId());
            this.receiveMessageLater(RECEIVING_BACKOFF_DELAY_WHEN_CACHE_IS_FULL);
            return;
        }
        this.receiveMessageImmediately();
    }

    private void receiveMessageImmediately() {
        if (!this.consumer.isRunning()) {
            LOGGER.info("Stop to receive message because consumer is not running, mq={}, clientId={}", (Object)this.mq, (Object)this.consumer.clientId());
            return;
        }
        try {
            final Endpoints endpoints = this.mq.getBroker().getEndpoints();
            int batchSize = this.getReceptionBatchSize();
            ReceiveMessageRequest request = this.consumer.wrapReceiveMessageRequest(batchSize, this.mq, this.filterExpression);
            this.activityNanoTime = System.nanoTime();
            this.consumer.doBefore(MessageHookPoints.RECEIVE, Collections.emptyList());
            final Stopwatch stopwatch = Stopwatch.createStarted();
            ListenableFuture<ReceiveMessageResult> future = this.consumer.receiveMessage(request, this.mq, this.consumer.getPushConsumerSettings().getLongPollingTimeout());
            Futures.addCallback(future, new FutureCallback<ReceiveMessageResult>(){

                @Override
                public void onSuccess(ReceiveMessageResult result) {
                    Duration duration = stopwatch.elapsed();
                    List<MessageCommon> commons = result.getMessageViewImpls().stream().map(MessageViewImpl::getMessageCommon).collect(Collectors.toList());
                    ProcessQueueImpl.this.consumer.doAfter(MessageHookPoints.RECEIVE, commons, duration, MessageHookPointsStatus.OK);
                    try {
                        ProcessQueueImpl.this.onReceiveMessageResult(result);
                    }
                    catch (Throwable t) {
                        LOGGER.error("[Bug] Exception raised while handling receive result, mq={}, endpoints={}, clientId={}", ProcessQueueImpl.this.mq, endpoints, ProcessQueueImpl.this.consumer.clientId(), t);
                        ProcessQueueImpl.this.onReceiveMessageException(t);
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    Duration duration = stopwatch.elapsed();
                    ProcessQueueImpl.this.consumer.doAfter(MessageHookPoints.RECEIVE, Collections.emptyList(), duration, MessageHookPointsStatus.ERROR);
                    LOGGER.error("Exception raised during message reception, mq={}, endpoints={}, clientId={}", ProcessQueueImpl.this.mq, endpoints, ProcessQueueImpl.this.consumer.clientId(), t);
                    ProcessQueueImpl.this.onReceiveMessageException(t);
                }
            }, MoreExecutors.directExecutor());
            this.receptionTimes.getAndIncrement();
            this.consumer.getReceptionTimes().getAndIncrement();
        }
        catch (Throwable t) {
            LOGGER.error("Exception raised during message reception, mq={}, clientId={}", this.mq, this.consumer.clientId(), t);
            this.onReceiveMessageException(t);
        }
    }

    public boolean isCacheFull() {
        long actualCachedMessagesBytes;
        long actualMessagesQuantity;
        int cacheMessageCountThresholdPerQueue = this.consumer.cacheMessageCountThresholdPerQueue();
        if ((long)cacheMessageCountThresholdPerQueue <= (actualMessagesQuantity = (long)this.cachedMessagesCount())) {
            LOGGER.warn("Process queue total cached messages quantity exceeds the threshold, threshold={}, actual={}, mq={}, clientId={}", cacheMessageCountThresholdPerQueue, actualMessagesQuantity, this.mq, this.consumer.clientId());
            return true;
        }
        int cacheMessageBytesThresholdPerQueue = this.consumer.cacheMessageBytesThresholdPerQueue();
        if ((long)cacheMessageBytesThresholdPerQueue <= (actualCachedMessagesBytes = this.cachedMessageBytes())) {
            LOGGER.warn("Process queue total cached messages memory exceeds the threshold, threshold={} bytes, actual={} bytes, mq={}, clientId={}", cacheMessageBytesThresholdPerQueue, actualCachedMessagesBytes, this.mq, this.consumer.clientId());
            return true;
        }
        return false;
    }

    public int cachedMessagesCount() {
        this.pendingMessagesLock.readLock().lock();
        this.inflightMessagesLock.readLock().lock();
        try {
            int n = this.pendingMessages.size() + this.inflightMessages.size();
            return n;
        }
        finally {
            this.inflightMessagesLock.readLock().unlock();
            this.pendingMessagesLock.readLock().unlock();
        }
    }

    public int inflightMessagesCount() {
        this.inflightMessagesLock.readLock().lock();
        try {
            int n = this.inflightMessages.size();
            return n;
        }
        finally {
            this.inflightMessagesLock.readLock().unlock();
        }
    }

    public long cachedMessageBytes() {
        return this.cachedMessagesBytes.get();
    }

    private void onReceiveMessageResult(ReceiveMessageResult result) {
        List<MessageViewImpl> messages = result.getMessageViewImpls();
        if (!messages.isEmpty()) {
            this.cacheMessages(messages);
            this.receivedMessagesQuantity.getAndAdd(messages.size());
            this.consumer.getReceivedMessagesQuantity().getAndAdd(messages.size());
            this.consumer.getConsumeService().signal();
        }
        this.receiveMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<MessageViewImpl> tryTakeMessage() {
        this.pendingMessagesLock.writeLock().lock();
        this.inflightMessagesLock.writeLock().lock();
        try {
            Optional<MessageViewImpl> first = this.pendingMessages.stream().findFirst();
            if (!first.isPresent()) {
                Optional<MessageViewImpl> optional = first;
                return optional;
            }
            MessageViewImpl messageView = (MessageViewImpl)first.get();
            this.inflightMessages.add(messageView);
            this.pendingMessages.remove(messageView);
            Optional<MessageViewImpl> optional = first;
            return optional;
        }
        finally {
            this.inflightMessagesLock.writeLock().unlock();
            this.pendingMessagesLock.writeLock().unlock();
        }
    }

    private void eraseMessage(MessageViewImpl messageView) {
        this.inflightMessagesLock.writeLock().lock();
        try {
            if (this.inflightMessages.remove(messageView)) {
                this.cachedMessagesBytes.addAndGet(-messageView.getBody().remaining());
            }
        }
        finally {
            this.inflightMessagesLock.writeLock().unlock();
        }
    }

    private void statsConsumptionResult(ConsumeResult consumeResult) {
        if (ConsumeResult.SUCCESS.equals((Object)consumeResult)) {
            this.consumer.consumptionOkQuantity.incrementAndGet();
            return;
        }
        this.consumer.consumptionErrorQuantity.incrementAndGet();
    }

    @Override
    public void eraseMessage(MessageViewImpl messageView, ConsumeResult consumeResult) {
        this.statsConsumptionResult(consumeResult);
        this.eraseMessage(messageView);
        if (ConsumeResult.SUCCESS.equals((Object)consumeResult)) {
            this.ackMessage(messageView);
            return;
        }
        this.nackMessage(messageView);
    }

    private void nackMessage(MessageViewImpl messageView) {
        int deliveryAttempt = messageView.getDeliveryAttempt();
        Duration duration = this.consumer.getRetryPolicy().getNextAttemptDelay(deliveryAttempt);
        this.changeInvisibleDuration(messageView, duration, 1);
    }

    private void changeInvisibleDuration(final MessageViewImpl messageView, final Duration duration, final int attempt) {
        final String clientId = this.consumer.clientId();
        final String consumerGroup = this.consumer.getConsumerGroup();
        final MessageId messageId = messageView.getMessageId();
        final Endpoints endpoints = messageView.getEndpoints();
        ListenableFuture<RpcInvocation<ChangeInvisibleDurationResponse>> future = this.consumer.changeInvisibleDuration(messageView, duration);
        Futures.addCallback(future, new FutureCallback<RpcInvocation<ChangeInvisibleDurationResponse>>(){

            @Override
            public void onSuccess(RpcInvocation<ChangeInvisibleDurationResponse> invocation) {
                ChangeInvisibleDurationResponse response = invocation.getResponse();
                String requestId = invocation.getContext().getRequestId();
                Status status = response.getStatus();
                Code code = status.getCode();
                if (Code.INVALID_RECEIPT_HANDLE.equals(code)) {
                    LOGGER.error("Failed to change invisible duration due to the invalid receipt handle, forgive to retry, clientId={}, consumerGroup={}, messageId={}, attempt={}, mq={}, endpoints={}, requestId={}, status message=[{}]", clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId, status.getMessage());
                    return;
                }
                if (!Code.OK.equals(code)) {
                    LOGGER.error("Failed to change invisible duration, would retry later, clientId={}, consumerGroup={}, messageId={}, attempt={}, mq={}, endpoints={}, requestId={}, status message=[{}]", clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId, status.getMessage());
                    ProcessQueueImpl.this.changeInvisibleDurationLater(messageView, duration, 1 + attempt);
                    return;
                }
                if (1 < attempt) {
                    LOGGER.info("Finally, change invisible duration successfully, clientId={}, consumerGroup={} messageId={}, attempt={}, mq={}, endpoints={}, requestId={}", clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId);
                    return;
                }
                LOGGER.debug("Change invisible duration successfully, clientId={}, consumerGroup={}, messageId={}, mq={}, endpoints={}, requestId={}", clientId, consumerGroup, messageId, ProcessQueueImpl.this.mq, endpoints, requestId);
            }

            @Override
            public void onFailure(Throwable t) {
                LOGGER.error("Exception raised while changing invisible duration, would retry later, clientId={}, consumerGroup={}, messageId={}, mq={}, endpoints={}", clientId, consumerGroup, messageId, ProcessQueueImpl.this.mq, endpoints, t);
                ProcessQueueImpl.this.changeInvisibleDurationLater(messageView, duration, 1 + attempt);
            }
        }, MoreExecutors.directExecutor());
    }

    private void changeInvisibleDurationLater(MessageViewImpl messageView, Duration duration, int attempt) {
        MessageId messageId = messageView.getMessageId();
        String clientId = this.consumer.clientId();
        if (this.dropped) {
            LOGGER.info("Process queue was dropped, give up to change invisible duration, mq={}, messageId={}, clientId={}", this.mq, messageId, clientId);
            return;
        }
        ScheduledExecutorService scheduler = this.consumer.getScheduler();
        try {
            scheduler.schedule(() -> this.changeInvisibleDuration(messageView, duration, attempt), CHANGE_INVISIBLE_DURATION_FAILURE_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            if (scheduler.isShutdown()) {
                return;
            }
            LOGGER.error("[Bug] Failed to schedule message change invisible duration request, mq={}, messageId={}, clientId={}", this.mq, messageId, clientId);
            this.changeInvisibleDurationLater(messageView, duration, 1 + attempt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<MessageViewImpl> tryTakeFifoMessages() {
        this.pendingMessagesLock.writeLock().lock();
        this.inflightMessagesLock.writeLock().lock();
        try {
            Optional next = this.pendingMessages.stream().findFirst();
            if (!next.isPresent()) {
                Iterator<MessageViewImpl> iterator = Collections.emptyIterator();
                return iterator;
            }
            MessageViewImpl first = (MessageViewImpl)next.get();
            Iterator<MessageViewImpl> iterator = first.iterator();
            iterator.forEachRemaining(messageView -> {
                this.pendingMessages.remove(messageView);
                this.inflightMessages.add((MessageViewImpl)messageView);
            });
            Iterator<MessageViewImpl> iterator2 = first.iterator();
            return iterator2;
        }
        finally {
            this.inflightMessagesLock.writeLock().unlock();
            this.pendingMessagesLock.writeLock().unlock();
        }
    }

    @Override
    public ListenableFuture<Void> eraseFifoMessage(MessageViewImpl messageView, ConsumeResult consumeResult) {
        this.statsConsumptionResult(consumeResult);
        RetryPolicy retryPolicy = this.consumer.getRetryPolicy();
        int maxAttempts = retryPolicy.getMaxAttempts();
        int attempt = messageView.getDeliveryAttempt();
        MessageId messageId = messageView.getMessageId();
        ConsumeService service = this.consumer.getConsumeService();
        String clientId = this.consumer.clientId();
        if (ConsumeResult.FAILURE.equals((Object)consumeResult) && attempt < maxAttempts) {
            Duration nextAttemptDelay = retryPolicy.getNextAttemptDelay(attempt);
            attempt = messageView.incrementAndGetDeliveryAttempt();
            LOGGER.debug("Prepare to redeliver the fifo message because of the consumption failure, maxAttempt={}, attempt={}, mq={}, messageId={}, nextAttemptDelay={}, clientId={}", maxAttempts, attempt, this.mq, messageId, nextAttemptDelay, clientId);
            ListenableFuture<ConsumeResult> future = service.consume(messageView, nextAttemptDelay);
            return Futures.transformAsync(future, result -> this.eraseFifoMessage(messageView, (ConsumeResult)((Object)result)), MoreExecutors.directExecutor());
        }
        boolean ok = ConsumeResult.SUCCESS.equals((Object)consumeResult);
        if (!ok) {
            LOGGER.info("Failed to consume fifo message finally, run out of attempt times, maxAttempts={}, attempt={}, mq={}, messageId={}, clientId={}", maxAttempts, attempt, this.mq, messageId, clientId);
        }
        ListenableFuture<Void> future = ok ? this.ackMessage(messageView) : this.forwardToDeadLetterQueue(messageView);
        future.addListener(() -> this.eraseMessage(messageView), this.consumer.getConsumptionExecutor());
        return future;
    }

    private ListenableFuture<Void> forwardToDeadLetterQueue(MessageViewImpl messageView) {
        SettableFuture<Void> future = SettableFuture.create();
        this.forwardToDeadLetterQueue(messageView, 1, future);
        return future;
    }

    private void forwardToDeadLetterQueue(final MessageViewImpl messageView, final int attempt, final SettableFuture<Void> future0) {
        ListenableFuture<RpcInvocation<ForwardMessageToDeadLetterQueueResponse>> future = this.consumer.forwardMessageToDeadLetterQueue(messageView);
        final String clientId = this.consumer.clientId();
        final String consumerGroup = this.consumer.getConsumerGroup();
        final MessageId messageId = messageView.getMessageId();
        final Endpoints endpoints = messageView.getEndpoints();
        Futures.addCallback(future, new FutureCallback<RpcInvocation<ForwardMessageToDeadLetterQueueResponse>>(){

            @Override
            public void onSuccess(RpcInvocation<ForwardMessageToDeadLetterQueueResponse> invocation) {
                ForwardMessageToDeadLetterQueueResponse response = invocation.getResponse();
                String requestId = invocation.getContext().getRequestId();
                Status status = response.getStatus();
                Code code = status.getCode();
                if (!Code.OK.equals(code)) {
                    LOGGER.error("Failed to forward message to dead letter queue, would attempt to re-forward later, clientId={}, consumerGroup={}, messageId={}, attempt={}, mq={}, endpoints={}, requestId={}, code={}, status message={}", clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId, code, status.getMessage());
                    ProcessQueueImpl.this.forwardToDeadLetterQueue(messageView, 1 + attempt, future0);
                    return;
                }
                future0.setFuture(Futures.immediateVoidFuture());
                if (1 < attempt) {
                    LOGGER.info("Re-forward message to dead letter queue successfully, clientId={}, consumerGroup={}, attempt={}, messageId={}, mq={}, endpoints={}, requestId={}", clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, endpoints, requestId);
                    return;
                }
                LOGGER.info("Forward message to dead letter queue successfully, clientId={}, consumerGroup={}, messageId={}, mq={}, endpoints={}, requestId={}", clientId, consumerGroup, messageId, ProcessQueueImpl.this.mq, endpoints, requestId);
            }

            @Override
            public void onFailure(Throwable t) {
                LOGGER.error("Exception raised while forward message to DLQ, would attempt to re-forward later, clientId={}, consumerGroup={}, attempt={}, messageId={}, mq={}", clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, t);
                ProcessQueueImpl.this.forwardToDeadLetterQueueLater(messageView, 1 + attempt, future0);
            }
        }, MoreExecutors.directExecutor());
    }

    private void forwardToDeadLetterQueueLater(MessageViewImpl messageView, int attempt, SettableFuture<Void> future0) {
        MessageId messageId = messageView.getMessageId();
        String clientId = this.consumer.clientId();
        if (this.dropped) {
            LOGGER.info("Process queue was dropped, give up to forward message to dead letter queue, mq={}, messageId={}, clientId={}", this.mq, messageId, clientId);
            return;
        }
        ScheduledExecutorService scheduler = this.consumer.getScheduler();
        try {
            scheduler.schedule(() -> this.forwardToDeadLetterQueue(messageView, attempt, future0), FORWARD_FIFO_MESSAGE_TO_DLQ_FAILURE_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            if (scheduler.isShutdown()) {
                return;
            }
            LOGGER.error("[Bug] Failed to schedule DLQ message request, mq={}, messageId={}, clientId={}", this.mq, messageView.getMessageId(), clientId);
            this.forwardToDeadLetterQueueLater(messageView, 1 + attempt, future0);
        }
    }

    private ListenableFuture<Void> ackMessage(MessageViewImpl messageView) {
        SettableFuture<Void> future = SettableFuture.create();
        this.ackMessage(messageView, 1, future);
        return future;
    }

    private void ackMessage(final MessageViewImpl messageView, final int attempt, final SettableFuture<Void> future0) {
        final String clientId = this.consumer.clientId();
        final String consumerGroup = this.consumer.getConsumerGroup();
        final MessageId messageId = messageView.getMessageId();
        final Endpoints endpoints = messageView.getEndpoints();
        ListenableFuture<RpcInvocation<AckMessageResponse>> future = this.consumer.ackMessage(messageView);
        Futures.addCallback(future, new FutureCallback<RpcInvocation<AckMessageResponse>>(){

            @Override
            public void onSuccess(RpcInvocation<AckMessageResponse> invocation) {
                AckMessageResponse response = invocation.getResponse();
                String requestId = invocation.getContext().getRequestId();
                Status status = response.getStatus();
                Code code = status.getCode();
                if (Code.INVALID_RECEIPT_HANDLE.equals(code)) {
                    LOGGER.error("Failed to ack message due to the invalid receipt handle, forgive to retry, clientId={}, consumerGroup={}, messageId={}, attempt={}, mq={}, endpoints={}, requestId={}, status message=[{}]", clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId, status.getMessage());
                    future0.setException(new BadRequestException(code.getNumber(), requestId, status.getMessage()));
                    return;
                }
                if (!Code.OK.equals(code)) {
                    LOGGER.error("Failed to ack message, would attempt to re-ack later, clientId={}, consumerGroup={}, attempt={}, messageId={}, mq={}, code={}, requestId={}, endpoints={}, status message=[{}]", clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, code, requestId, endpoints, status.getMessage());
                    ProcessQueueImpl.this.ackMessageLater(messageView, 1 + attempt, future0);
                    return;
                }
                future0.setFuture(Futures.immediateVoidFuture());
                if (1 < attempt) {
                    LOGGER.info("Finally, ack message successfully, clientId={}, consumerGroup={}, attempt={}, messageId={}, mq={}, endpoints={}, requestId={}", clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, endpoints, requestId);
                    return;
                }
                LOGGER.debug("Ack message successfully, clientId={}, consumerGroup={}, messageId={}, mq={}, endpoints={}, requestId={}", clientId, consumerGroup, messageId, ProcessQueueImpl.this.mq, endpoints, requestId);
            }

            @Override
            public void onFailure(Throwable t) {
                LOGGER.error("Exception raised while acknowledging message, clientId={}, consumerGroup={}, would attempt to re-ack later, attempt={}, messageId={}, mq={}, endpoints={}", clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, endpoints, t);
                ProcessQueueImpl.this.ackMessageLater(messageView, 1 + attempt, future0);
            }
        }, MoreExecutors.directExecutor());
    }

    private void ackMessageLater(MessageViewImpl messageView, int attempt, SettableFuture<Void> future0) {
        MessageId messageId = messageView.getMessageId();
        String clientId = this.consumer.clientId();
        if (this.dropped) {
            LOGGER.info("Process queue was dropped, give up to ack message, mq={}, messageId={}, clientId={}", this.mq, messageId, clientId);
            return;
        }
        ScheduledExecutorService scheduler = this.consumer.getScheduler();
        try {
            scheduler.schedule(() -> this.ackMessage(messageView, attempt, future0), ACK_MESSAGE_FAILURE_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            if (scheduler.isShutdown()) {
                return;
            }
            LOGGER.error("[Bug] Failed to schedule message ack request, mq={}, messageId={}, clientId={}", this.mq, messageId, clientId);
            this.ackMessageLater(messageView, 1 + attempt, future0);
        }
    }

    @Override
    public long getPendingMessageCount() {
        this.pendingMessagesLock.readLock().lock();
        try {
            long l = this.pendingMessages.size();
            return l;
        }
        finally {
            this.pendingMessagesLock.readLock().unlock();
        }
    }

    @Override
    public long getInflightMessageCount() {
        this.inflightMessagesLock.readLock().lock();
        try {
            long l = this.inflightMessages.size();
            return l;
        }
        finally {
            this.inflightMessagesLock.readLock().unlock();
        }
    }

    @Override
    public long getCachedMessageBytes() {
        return this.cachedMessagesBytes.get();
    }

    @Override
    public void doStats() {
        long receptionTimes = this.receptionTimes.getAndSet(0L);
        long receivedMessagesQuantity = this.receivedMessagesQuantity.getAndSet(0L);
        LOGGER.info("Process queue stats: clientId={}, mq={}, receptionTimes={}, receivedMessageQuantity={}, pendingMessageCount={}, inflightMessageCount={}, cachedMessageBytes={}", this.consumer.clientId(), this.mq, receptionTimes, receivedMessagesQuantity, this.getPendingMessageCount(), this.getInflightMessageCount(), this.getCachedMessageBytes());
    }
}

