/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics;

import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.DoubleCounter;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.DoubleCounterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.ObservableDoubleCounter;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.AbstractInstrument;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.InstrumentValueType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.SdkObservableInstrument;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.instrument.BoundDoubleCounter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkDoubleCounter
extends AbstractInstrument
implements DoubleCounter {
    private static final Logger logger = Logger.getLogger(SdkDoubleCounter.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkDoubleCounter(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void add(double increment, Attributes attributes, Context context) {
        if (increment < 0.0) {
            this.throttlingLogger.log(Level.WARNING, "Counters can only increase. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(increment, attributes, context);
    }

    @Override
    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    BoundDoubleCounter bind(Attributes attributes) {
        return new BoundInstrument(this.getDescriptor(), this.storage.bind(attributes), attributes);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static final class BoundInstrument
    implements BoundDoubleCounter {
        private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(SdkDoubleCounter.access$000());
        private final InstrumentDescriptor descriptor;
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(InstrumentDescriptor descriptor, BoundStorageHandle handle, Attributes attributes) {
            this.descriptor = descriptor;
            this.handle = handle;
            this.attributes = attributes;
        }

        @Override
        public void add(double increment, Context context) {
            if (increment < 0.0) {
                this.throttlingLogger.log(Level.WARNING, "Counters can only increase. Instrument " + this.descriptor.getName() + " has recorded a negative value.");
                return;
            }
            this.handle.recordDouble(increment, this.attributes, context);
        }

        @Override
        public void add(double increment) {
            this.add(increment, Context.current());
        }

        @Override
        public void unbind() {
            this.handle.release();
        }
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements DoubleCounterBuilder {
        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, name, description, unit);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SdkDoubleCounter build() {
            return this.buildSynchronousInstrument(InstrumentType.COUNTER, InstrumentValueType.DOUBLE, (x$0, x$1) -> new SdkDoubleCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return new SdkObservableInstrument(this.meterSharedState, this.registerDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_COUNTER, callback));
        }
    }
}

