/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public final class FortifyUtils {
    private static Method getMessageMethod;
    private static Method printStackTraceMethod;

    private FortifyUtils() {
    }

    public static String getErrorMsg(Throwable e) {
        if (e == null) {
            return "";
        }
        try {
            return (String)getMessageMethod.invoke((Object)e, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            return "";
        }
    }

    public static String getErrorStack(Throwable e) {
        if (null == e) {
            return "";
        }
        try {
            StringWriter errors = new StringWriter();
            printStackTraceMethod.invoke((Object)e, new PrintWriter(errors));
            return errors.toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            return "";
        }
    }

    public static String getErrorInfo(Throwable e) {
        return FortifyUtils.getErrorInfo(e, true);
    }

    public static String getErrorInfo(Throwable e, boolean isPrintMsg) {
        StringBuffer error = new StringBuffer(System.lineSeparator());
        error.append("Exception: ").append(e.getClass().getName()).append("; ");
        if (isPrintMsg) {
            error.append(FortifyUtils.getErrorMsg(e)).append(System.lineSeparator());
        }
        error.append(FortifyUtils.getErrorStack(e));
        return error.toString();
    }

    public static DocumentBuilderFactory getSecurityXmlDocumentFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setValidating(true);
        return factory;
    }

    static {
        try {
            getMessageMethod = Throwable.class.getMethod("getMessage", new Class[0]);
            printStackTraceMethod = Throwable.class.getMethod("printStackTrace", PrintWriter.class);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

