/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.exception;

import javax.ws.rs.core.Response;
import org.apache.servicecomb.swagger.invocation.context.HttpStatus;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;

public class InvocationException
extends RuntimeException {
    private static final long serialVersionUID = 8027482777502649656L;
    private Response.StatusType status;
    private Object errorData;

    public InvocationException(Response.StatusType status, Object errorData) {
        this.status = status;
        this.errorData = errorData;
    }

    public InvocationException(Response.StatusType status, String msg) {
        this.status = status;
        this.errorData = new CommonExceptionData(msg);
    }

    public InvocationException(int statusCode, String reasonPhrase, Object errorData, Throwable cause) {
        super(cause);
        this.status = new HttpStatus(statusCode, reasonPhrase);
        this.errorData = errorData;
    }

    public InvocationException(int statusCode, String reasonPhrase, Object errorData) {
        this.status = new HttpStatus(statusCode, reasonPhrase);
        this.errorData = errorData;
    }

    public Response.StatusType getStatus() {
        return this.status;
    }

    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    public String getReasonPhrase() {
        return this.status.getReasonPhrase();
    }

    public Object getErrorData() {
        return this.errorData;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InvocationException: code=");
        sb.append(this.getStatusCode());
        sb.append(";msg=");
        sb.append(this.getErrorData());
        return sb.toString();
    }
}

