/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeMap;
import io.reactivex.netty.contexts.AbstractContextHandler;
import io.reactivex.netty.contexts.ContextAttributeStorageHelper;
import io.reactivex.netty.contexts.ContextKeySupplier;
import io.reactivex.netty.contexts.ContextsContainer;
import io.reactivex.netty.contexts.ContextsContainerImpl;
import io.reactivex.netty.contexts.RequestCorrelator;
import io.reactivex.netty.contexts.RequestIdProvider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerContextHandler<R, W>
extends AbstractContextHandler<R, W> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractServerContextHandler.class);
    protected final RequestIdProvider requestIdProvider;
    protected final RequestCorrelator correlator;

    protected AbstractServerContextHandler(RequestCorrelator correlator, RequestIdProvider requestIdProvider) {
        this.correlator = correlator;
        this.requestIdProvider = requestIdProvider;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.isAcceptableToRead(msg)) {
            Object request = msg;
            ContextKeySupplier keySupplier = this.newKeySupplierForRead(request);
            String requestId = this.requestIdProvider.onServerRequest(keySupplier, (AttributeMap)ctx);
            if (null == requestId) {
                requestId = this.requestIdProvider.newRequestId(keySupplier, (AttributeMap)ctx);
            }
            ContextsContainer contextsContainer = this.newContextContainer(keySupplier);
            ContextAttributeStorageHelper.setContainer(ctx, requestId, contextsContainer);
            this.correlator.onNewServerRequest(requestId, contextsContainer);
        }
        super.channelRead(ctx, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try {
            Object response;
            ContextKeySupplier keySupplier;
            String requestId;
            if (this.isAcceptableToWrite(msg) && null != (requestId = this.requestIdProvider.beforeServerResponse(keySupplier = this.newKeySupplierForWrite(response = msg), (AttributeMap)ctx))) {
                this.newRequestIdWritten(requestId);
                ContextsContainer container = ContextAttributeStorageHelper.getContainer(ctx, requestId);
                if (null != container) {
                    Map<String, String> modifiedCtxs = container.getModifiedBidirectionalContexts();
                    for (Map.Entry<String, String> modifiedCtxEntry : modifiedCtxs.entrySet()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Added a modified bi-directional context key. Name: " + modifiedCtxEntry.getKey() + ", value: " + modifiedCtxEntry.getValue());
                        }
                        this.addKey(response, modifiedCtxEntry.getKey(), modifiedCtxEntry.getValue());
                    }
                }
            }
            super.write(ctx, msg, promise);
        }
        finally {
            String currentRequestId = this.getCurrentlyProcessingRequestId();
            if (null != currentRequestId && this.isLastResponseFragmenTotWrite(msg)) {
                this.correlator.onClientProcessingEnd(currentRequestId);
            }
        }
    }

    protected abstract void newRequestIdWritten(String var1);

    protected abstract String getCurrentlyProcessingRequestId();

    protected abstract boolean isLastResponseFragmenTotWrite(Object var1);

    protected ContextsContainer newContextContainer(ContextKeySupplier keySupplier) {
        return new ContextsContainerImpl(keySupplier);
    }
}

