/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.loader.SchemaListenerManager;
import org.apache.servicecomb.core.definition.schema.StaticSchemaFactory;
import org.apache.servicecomb.core.provider.consumer.ConsumerProviderManager;
import org.apache.servicecomb.core.provider.producer.ProducerProviderManager;
import org.apache.servicecomb.core.transport.TransportManager;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.Ordered;

public class CseApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered,
ApplicationContextAware {
    private Class<?> initEventClass = ContextRefreshedEvent.class;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        BeanUtils.setContext((ApplicationContext)applicationContext);
        RegistryUtils.init();
    }

    public void setInitEventClass(Class<?> initEventClass) {
        this.initEventClass = initEventClass;
    }

    public int getOrder() {
        return -1000;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.initEventClass.isInstance(event)) {
            if (this.applicationContext instanceof AbstractApplicationContext) {
                ((AbstractApplicationContext)this.applicationContext).registerShutdownHook();
            }
            if (SCBEngine.getInstance().getBootListenerList() == null) {
                String serviceName = RegistryUtils.getMicroservice().getServiceName();
                SCBEngine.getInstance().setProducerMicroserviceMeta(new MicroserviceMeta(serviceName).setConsumer(false));
                SCBEngine.getInstance().setProducerProviderManager((ProducerProviderManager)this.applicationContext.getBean(ProducerProviderManager.class));
                SCBEngine.getInstance().setConsumerProviderManager((ConsumerProviderManager)this.applicationContext.getBean(ConsumerProviderManager.class));
                SCBEngine.getInstance().setTransportManager((TransportManager)this.applicationContext.getBean(TransportManager.class));
                SCBEngine.getInstance().setSchemaListenerManager((SchemaListenerManager)this.applicationContext.getBean(SchemaListenerManager.class));
                SCBEngine.getInstance().setBootListenerList(this.applicationContext.getBeansOfType(BootListener.class).values());
                SCBEngine.getInstance().setStaticSchemaFactory((StaticSchemaFactory)this.applicationContext.getBean(StaticSchemaFactory.class));
            }
            SCBEngine.getInstance().init();
        } else if (event instanceof ContextClosedEvent) {
            SCBEngine.getInstance().destroy();
        }
    }
}

