/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.jmx.DataConverter;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpoint;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class EndpointMBean
implements JmxEndpoint {
    private final DataConverter dataConverter;
    private final Endpoint<?> endpoint;

    public EndpointMBean(String beanName, Endpoint<?> endpoint, ObjectMapper objectMapper) {
        this.dataConverter = new DataConverter(objectMapper);
        Assert.notNull((Object)beanName, (String)"BeanName must not be null");
        Assert.notNull(endpoint, (String)"Endpoint must not be null");
        this.endpoint = endpoint;
    }

    @ManagedAttribute(description="Returns the class of the underlying endpoint")
    public String getEndpointClass() {
        return ClassUtils.getQualifiedName(this.getEndpointType());
    }

    @Override
    public boolean isEnabled() {
        return this.endpoint.isEnabled();
    }

    @ManagedAttribute(description="Indicates whether the underlying endpoint exposes sensitive information")
    public boolean isSensitive() {
        return this.endpoint.isSensitive();
    }

    @Override
    public String getIdentity() {
        return ObjectUtils.getIdentityHexString(this.getEndpoint());
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return this.getEndpoint().getClass();
    }

    public Endpoint<?> getEndpoint() {
        return this.endpoint;
    }

    protected Object convert(Object data) {
        return this.dataConverter.convert(data);
    }
}

