/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.ConfigurationManager;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceFactory;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.lightweight.MicroserviceInfo;
import org.apache.servicecomb.registry.lightweight.RegisterRequest;
import org.apache.servicecomb.registry.lightweight.UnregisterRequest;
import org.apache.servicecomb.registry.swagger.SwaggerLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class Self
implements InitializingBean,
BootListener {
    private Microservice microservice;
    private boolean crossApp;
    private String schemasSummary;
    private MicroserviceInstance instance;
    private final MicroserviceInfo microserviceInfo = new MicroserviceInfo();

    public void afterPropertiesSet() {
        this.init(ConfigurationManager.getConfigInstance());
    }

    @VisibleForTesting
    public Self init(AbstractConfiguration configuration) {
        this.microservice = new MicroserviceFactory().create((Configuration)configuration);
        this.microservice.serviceId(String.format("%s/%s/%s/%s", this.microservice.getEnvironment(), this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion()));
        this.instance = this.microservice.getInstance().instanceId(UUID.randomUUID().toString()).serviceId(this.microservice.getServiceId());
        this.microserviceInfo.setMicroservice(this.microservice).setSchemasById(this.microservice.getSchemaMap()).setInstance(this.instance);
        return this;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void onBeforeRegistry(BootListener.BootEvent event) {
        this.schemasSummary = this.calcSchemasSummary();
        this.crossApp = this.microservice.allowCrossApp();
    }

    public Microservice getMicroservice() {
        return this.microservice;
    }

    public String getAppId() {
        return this.microservice.getAppId();
    }

    public Microservice setServiceName(String serviceName) {
        return this.microservice.serviceName(serviceName);
    }

    public String getVersion() {
        return this.microservice.getVersion();
    }

    public String getInstanceId() {
        return this.instance.getInstanceId();
    }

    public String getServiceId() {
        return this.instance.getServiceId();
    }

    public MicroserviceInstance getInstance() {
        return this.instance;
    }

    public MicroserviceInfo getMicroserviceInfo() {
        return this.microserviceInfo;
    }

    public Self addSchema(String schemaId, String content) {
        this.microservice.addSchema(schemaId, content);
        this.schemasSummary = null;
        return this;
    }

    public Self addEndpoint(String endpoint) {
        this.instance.getEndpoints().add(endpoint);
        return this;
    }

    public String getSchemasSummary() {
        return this.schemasSummary;
    }

    private String calcSchemasSummary() {
        String content = this.microservice.getSchemaMap().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.joining("\n", "", ""));
        return SwaggerLoader.calcSchemaSummary((String)content);
    }

    public RegisterRequest buildRegisterRequest() {
        return this.createRegisterRequest().setAppId(this.microservice.getAppId()).setServiceId(this.microservice.getServiceId()).setCrossApp(this.crossApp).setSchemasSummary(this.schemasSummary).setInstanceId(this.instance.getInstanceId()).setStatus(this.instance.getStatus()).setEndpoints(this.instance.getEndpoints());
    }

    protected RegisterRequest createRegisterRequest() {
        return new RegisterRequest();
    }

    public UnregisterRequest buildUnregisterRequest() {
        return this.createUnregisterRequest().setServiceId(this.microservice.getServiceId()).setInstanceId(this.instance.getInstanceId());
    }

    protected UnregisterRequest createUnregisterRequest() {
        return new UnregisterRequest();
    }
}

