/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter.inner;

import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.buffer.Buffer;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.codec.produce.ProduceEventStreamProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.common.rest.filter.inner.RestServerCodecFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.concurrency.SuppressedRunnableWrapper;
import org.apache.servicecomb.foundation.common.utils.PartUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRestArgsFilter
implements HttpServerFilter {
    private static final boolean enabled = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.http.filter.server.serverRestArgs.enabled", true).get();
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerRestArgsFilter.class);

    @Override
    public int getOrder() {
        return -100;
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public Response afterReceiveRequest(Invocation invocation, HttpServletRequestEx requestEx) {
        OperationMeta operationMeta = invocation.getOperationMeta();
        RestOperationMeta restOperationMeta = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        Map<String, Object> swaggerArguments = RestCodec.restToArgs((HttpServletRequest)requestEx, restOperationMeta);
        invocation.setSwaggerArguments(swaggerArguments);
        return null;
    }

    @Override
    public CompletableFuture<Void> beforeSendResponseAsync(Invocation invocation, HttpServletResponseEx responseEx) {
        Response response = (Response)responseEx.getAttribute("servicecomb-invocation-hanlder-response");
        ProduceProcessor produceProcessor = (ProduceProcessor)responseEx.getAttribute("servicecomb-invocation-hanlder-processor");
        boolean failed = response.getResult() instanceof InvocationException;
        if (!failed && RestServerCodecFilter.isDownloadFileResponseType(invocation, response)) {
            return responseEx.sendPart(PartUtils.getSinglePart(null, (Object)response.getResult()));
        }
        if (ServerRestArgsFilter.isServerSendEvent(response)) {
            produceProcessor = new ProduceEventStreamProcessor();
            responseEx.setContentType(produceProcessor.getName() + "; charset=utf-8");
            return ServerRestArgsFilter.writeServerSendEvent(invocation, response, produceProcessor, responseEx);
        }
        responseEx.setContentType(produceProcessor.getName() + "; charset=utf-8");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try (BufferOutputStream output = new BufferOutputStream(Buffer.buffer());){
            if (failed) {
                produceProcessor.encodeResponse((OutputStream)output, ((InvocationException)((Object)response.getResult())).getErrorData());
            } else {
                produceProcessor.encodeResponse((OutputStream)output, response.getResult());
            }
            responseEx.setBodyBuffer(output.getBuffer());
            future.complete(null);
        }
        catch (Throwable e) {
            future.completeExceptionally(ExceptionFactory.convertProducerException((Throwable)e));
        }
        return future;
    }

    public static boolean isServerSendEvent(Response response) {
        return response.getResult() instanceof Publisher;
    }

    private static CompletableFuture<Void> writeServerSendEvent(Invocation invocation, final Response response, final ProduceProcessor produceProcessor, final HttpServletResponseEx responseEx) {
        responseEx.setChunkedForEvent(true);
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        Publisher publisher = (Publisher)response.getResult();
        publisher.subscribe((Subscriber)new Subscriber<Object>(){
            Subscription subscription;

            public void onSubscribe(Subscription s) {
                s.request(1L);
                this.subscription = s;
            }

            public void onNext(Object o) {
                ((CompletableFuture)ServerRestArgsFilter.writeResponse(responseEx, produceProcessor, o, response).thenApply(r -> {
                    this.subscription.request(1L);
                    return r;
                })).exceptionally(e -> {
                    new SuppressedRunnableWrapper(() -> this.subscription.cancel()).run();
                    new SuppressedRunnableWrapper(() -> result.completeExceptionally((Throwable)e)).run();
                    return response;
                });
            }

            public void onError(Throwable t) {
                result.completeExceptionally(t);
            }

            public void onComplete() {
                result.complete(null);
            }
        });
        return result;
    }

    private static CompletableFuture<Response> writeResponse(HttpServletResponseEx responseEx, ProduceProcessor produceProcessor, Object data, Response response) {
        CompletionStage completionStage;
        BufferOutputStream output = new BufferOutputStream(Buffer.buffer());
        try {
            produceProcessor.encodeResponse((OutputStream)output, data);
            completionStage = responseEx.sendBuffer(output.getBuffer()).thenApply(v -> {
                try {
                    responseEx.flushBuffer();
                    return response;
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to flush buffer for Server Send Events", (Throwable)e);
                    throw new IllegalStateException("Failed to flush buffer for Server Send Events", e);
                }
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                LOGGER.error("internal service error must be fixed.", e);
                return CompletableFuture.failedFuture(e);
            }
        }
        output.close();
        return completionStage;
    }
}

