/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie;

import java.util.Collections;
import java.util.List;
import org.springframework.core.env.Environment;

public class KieConfig {
    public static final String SSL_TAG = "kie.consumer";
    private static final String SERVER_URL_KEY = "servicecomb.kie.serverUri";
    private static final String REFRESH_INTERVAL = "servicecomb.kie.refreshInterval";
    private static final String FIRST_REFRESH_INTERVAL = "servicecomb.kie.firstRefreshInterval";
    private static final String DOMAIN_NAME = "servicecomb.kie.domainName";
    private static final String ENABLE_LONG_POLLING = "servicecomb.kie.enableLongPolling";
    private static final String POLLING_WAIT_TIME = "servicecomb.kie.pollingWaitTime";
    private static final String FIRST_PULL_REQUIRED = "servicecomb.kie.firstPullRequired";
    private static final String CUSTOM_LABEL = "servicecomb.kie.customLabel";
    private static final String CUSTOM_LABEL_VALUE = "servicecomb.kie.customLabelValue";
    private static final String ENABLE_APP_CONFIG = "servicecomb.kie.enableAppConfig";
    private static final String ENABLE_SERVICE_CONFIG = "servicecomb.kie.enableServiceConfig";
    private static final String ENABLE_VERSION_CONFIG = "servicecomb.kie.enableVersionConfig";
    private static final String ENABLE_CUSTOM_CONFIG = "servicecomb.kie.enableCustomConfig";
    public static final String FILE_SOURCE = "servicecomb.config.client.fileSource";
    private static final int DEFAULT_REFRESH_INTERVAL = 15000;
    private static final int DEFAULT_POLLING_WAIT_TIME = 10;
    private static final int DEFAULT_FIRST_REFRESH_INTERVAL = 0;
    private static final boolean DEFAULT_ENABLE_LONG_POLLING = true;
    private static final String CUSTOM_LABEL_DEFAULT = "public";
    private static final String CUSTOM_LABEL_VALUE_DEFAULT = "";
    private final Environment environment;

    public KieConfig(Environment environment) {
        this.environment = environment;
    }

    public List<String> getFileSources() {
        return (List)this.environment.getProperty(FILE_SOURCE, List.class, Collections.emptyList());
    }

    public String getDomainName() {
        return this.environment.getProperty(DOMAIN_NAME, "default");
    }

    public String getServerUri() {
        return this.environment.getProperty(SERVER_URL_KEY);
    }

    public int getRefreshInterval() {
        return (Integer)this.environment.getProperty(REFRESH_INTERVAL, Integer.TYPE, (Object)15000);
    }

    public int getFirstRefreshInterval() {
        return (Integer)this.environment.getProperty(FIRST_REFRESH_INTERVAL, Integer.TYPE, (Object)0);
    }

    public boolean enableAppConfig() {
        return (Boolean)this.environment.getProperty(ENABLE_APP_CONFIG, Boolean.TYPE, (Object)true);
    }

    public boolean enableServiceConfig() {
        return (Boolean)this.environment.getProperty(ENABLE_SERVICE_CONFIG, Boolean.TYPE, (Object)true);
    }

    public boolean enableVersionConfig() {
        return (Boolean)this.environment.getProperty(ENABLE_VERSION_CONFIG, Boolean.TYPE, (Object)true);
    }

    public boolean enableCustomConfig() {
        return (Boolean)this.environment.getProperty(ENABLE_CUSTOM_CONFIG, Boolean.TYPE, (Object)true);
    }

    public boolean enableLongPolling() {
        return (Boolean)this.environment.getProperty(ENABLE_LONG_POLLING, Boolean.TYPE, (Object)true);
    }

    public int getPollingWaitTime() {
        return (Integer)this.environment.getProperty(POLLING_WAIT_TIME, Integer.TYPE, (Object)10);
    }

    public boolean firstPullRequired() {
        return (Boolean)this.environment.getProperty(FIRST_PULL_REQUIRED, Boolean.TYPE, (Object)false);
    }

    public String getCustomLabel() {
        return this.environment.getProperty(CUSTOM_LABEL, CUSTOM_LABEL_DEFAULT);
    }

    public String getCustomLabelValue() {
        return this.environment.getProperty(CUSTOM_LABEL_VALUE, CUSTOM_LABEL_VALUE_DEFAULT);
    }

    public Boolean isProxyEnable() {
        return (Boolean)this.environment.getProperty("servicecomb.proxy.enable", Boolean.TYPE, (Object)false);
    }

    public String getProxyHost() {
        return this.environment.getProperty("servicecomb.proxy.host", "127.0.0.1");
    }

    public int getProxyPort() {
        return (Integer)this.environment.getProperty("servicecomb.proxy.port", Integer.TYPE, (Object)8080);
    }

    public String getProxyUsername() {
        return this.environment.getProperty("servicecomb.proxy.username");
    }

    public String getProxyPasswd() {
        return this.environment.getProperty("servicecomb.proxy.passwd");
    }
}

