/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.shared.common.error.StandardException;

class SavepointNode
extends DDLStatementNode {
    private String savepointName;
    private int savepointStatementType;

    SavepointNode(String string, int n, ContextManager contextManager) throws StandardException {
        super(contextManager);
        this.savepointName = string;
        this.savepointStatementType = n;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        if (this.savepointStatementType == 1) {
            return "SAVEPOINT";
        }
        if (this.savepointStatementType == 2) {
            return "ROLLBACK WORK TO SAVEPOINT";
        }
        return "RELEASE TO SAVEPOINT";
    }

    @Override
    public boolean needsSavepoint() {
        return false;
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSavepointConstantAction(this.savepointName, this.savepointStatementType);
    }
}

