/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.saml2.impl;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.saml2.AuthenticationHandlerSAML2;
import org.apache.sling.auth.saml2.AuthenticationHandlerSAML2Config;
import org.apache.sling.auth.saml2.Helpers;
import org.apache.sling.auth.saml2.SAML2RuntimeException;
import org.apache.sling.auth.saml2.Saml2User;
import org.apache.sling.auth.saml2.Saml2UserMgtService;
import org.apache.sling.auth.saml2.impl.AbstractSamlHandler;
import org.apache.sling.auth.saml2.impl.Saml2Credentials;
import org.apache.sling.auth.saml2.impl.TokenStore;
import org.apache.sling.auth.saml2.sp.KeyPairCredentials;
import org.apache.sling.auth.saml2.sp.SamlReason;
import org.apache.sling.auth.saml2.sp.SessionStorage;
import org.apache.sling.auth.saml2.sp.VerifySignatureCredentials;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AuthenticationHandler.class}, name="org.apache.sling.auth.saml2.AuthenticationHandlerSAML2", configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"sling.servlet.methods={GET, POST}", "path={}", "authtype=SAML2", "service.description=SAML2 Authentication Handler", "service.ranking:Integer=42"})
@Designate(ocd=AuthenticationHandlerSAML2Config.class, factory=true)
public class AuthenticationHandlerSAML2Impl
extends AbstractSamlHandler
implements AuthenticationHandlerSAML2 {
    @Reference
    private Saml2UserMgtService saml2UserMgtService;
    public static final String AUTH_STORAGE_SESSION_TYPE = "session";
    public static final String AUTH_TYPE = "SAML2";
    static final String TOKEN_FILENAME = "saml2-cookie-tokens.bin";
    private SessionStorage storageAuthInfo;
    long sessionTimeout;
    private static Logger logger = LoggerFactory.getLogger(AuthenticationHandlerSAML2Impl.class);
    static final String SERVICE_NAME = "org.apache.sling.auth.saml2.AuthenticationHandlerSAML2";
    private Credential spKeypair;
    private Credential idpVerificationCert;
    private static final String REQUEST_METHOD = "POST";
    private static final long MINUTES = 60000L;
    private static final long TIMEOUT_MIN = 240L;
    private TokenStore tokenStore;

    @Activate
    @Modified
    protected void activate(AuthenticationHandlerSAML2Config config, ComponentContext componentContext) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, IOException {
        this.setConfigs(config);
        File tokenFile = this.getTokenFile(componentContext.getBundleContext());
        this.initializeTokenStore(tokenFile);
        if (this.getSaml2SPEncryptAndSign()) {
            this.idpVerificationCert = VerifySignatureCredentials.getCredential(this.getJksFileLocation(), this.getJksStorePassword().toCharArray(), this.getIdpCertAlias());
            this.spKeypair = KeyPairCredentials.getCredential(this.getJksFileLocation(), this.getJksStorePassword().toCharArray(), this.getSpKeysAlias(), this.getSpKeysPassword().toCharArray());
        }
    }

    void initializeTokenStore(File file) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        this.storageAuthInfo = new SessionStorage("authenticated");
        this.sessionTimeout = 14400000L;
        this.tokenStore = new TokenStore(file, this.sessionTimeout, false);
    }

    TokenStore getTokenStore() {
        return this.tokenStore;
    }

    Credential getSpKeypair() {
        return this.spKeypair;
    }

    Credential getIdpVerificationCert() {
        return this.idpVerificationCert;
    }

    SessionStorage getStorageAuthInfo() {
        return this.storageAuthInfo;
    }

    public AuthenticationInfo extractCredentials(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String authData;
        if (!this.getSaml2SPEnabled()) {
            return null;
        }
        String reqURI = httpServletRequest.getRequestURI();
        if (reqURI.equals(this.getAcsPath())) {
            return this.processAssertionConsumerService(httpServletRequest);
        }
        if (!this.getSaml2Path().isEmpty() && reqURI.startsWith(this.getSaml2Path()) && (authData = this.getStorageAuthInfo().getString(httpServletRequest)) != null) {
            if (this.tokenStore.isValid(authData)) {
                return this.buildAuthInfo(authData);
            }
            this.clearSessionAttributes(httpServletRequest);
            if (AuthUtil.isValidateRequest((HttpServletRequest)httpServletRequest)) {
                httpServletRequest.setAttribute("j_reason", (Object)SamlReason.TIMEOUT);
                return AuthenticationInfo.FAIL_AUTH;
            }
        }
        return null;
    }

    private void clearSessionAttributes(HttpServletRequest httpServletRequest) {
        this.getStorageAuthInfo().clear(httpServletRequest);
    }

    private AuthenticationInfo processAssertionConsumerService(HttpServletRequest httpServletRequest) {
        this.doClassloading();
        MessageContext messageContext = this.decodeHttpPostSamlResp(httpServletRequest);
        Assertion assertion = null;
        boolean relayStateIsOk = this.validateRelayState(httpServletRequest, messageContext);
        if (relayStateIsOk) {
            Response response = (Response)messageContext.getMessage();
            if (this.getSaml2SPEncryptAndSign()) {
                EncryptedAssertion encryptedAssertion = (EncryptedAssertion)response.getEncryptedAssertions().get(0);
                assertion = this.decryptAssertion(encryptedAssertion);
                this.verifyAssertionSignature(assertion);
            } else {
                assertion = (Assertion)response.getAssertions().get(0);
            }
            if (this.validateSaml2Conditions(httpServletRequest, assertion)) {
                logger.debug("Decrypted Assertion: ");
                User extUser = this.doUserManagement(assertion);
                return this.buildAuthInfo(extUser);
            }
            logger.error("Validation of SubjectConfirmation failed");
        }
        return null;
    }

    public boolean requestCredentials(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.ignoreRequestCredentials(httpServletRequest)) {
            return false;
        }
        if (this.getSaml2SPEnabled()) {
            this.doClassloading();
            this.setGotoURLOnSession(httpServletRequest);
            this.redirectUserForAuthentication(httpServletRequest, httpServletResponse);
            return true;
        }
        return false;
    }

    void doClassloading() {
        BundleWiring bundleWiring = (BundleWiring)FrameworkUtil.getBundle(AuthenticationHandlerSAML2Impl.class).adapt(BundleWiring.class);
        ClassLoader loader = bundleWiring.getClassLoader();
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(loader);
    }

    private void setGotoURLOnSession(HttpServletRequest request) {
        SessionStorage sessionStorage = new SessionStorage("gotoURL");
        sessionStorage.setString(request, request.getRequestURL().toString());
    }

    private void redirectUserForAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AuthnRequest authnRequest = this.buildAuthnRequest();
        this.redirectUserWithRequest(httpServletRequest, httpServletResponse, (RequestAbstractType)authnRequest);
    }

    boolean ignoreRequestCredentials(HttpServletRequest request) {
        String requestLogin = request.getParameter("sling:authRequestLogin");
        return requestLogin != null && !AUTH_TYPE.equals(requestLogin);
    }

    private void redirectUserWithRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RequestAbstractType requestForIDP) {
        MessageContext context = new MessageContext();
        context.setMessage((Object)requestForIDP);
        SAMLBindingContext bindingContext = (SAMLBindingContext)context.getSubcontext(SAMLBindingContext.class, true);
        SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)context.getSubcontext(SAMLPeerEntityContext.class, true);
        SAMLEndpointContext endpointContext = (SAMLEndpointContext)peerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        if (requestForIDP instanceof AuthnRequest) {
            this.setRelayStateOnSession(httpServletRequest, bindingContext);
            this.setRequestIDOnSession(httpServletRequest, (AuthnRequest)requestForIDP);
            endpointContext.setEndpoint(this.getIPDEndpoint());
        }
        SignatureSigningParameters signatureSigningParameters = new SignatureSigningParameters();
        signatureSigningParameters.setSigningCredential(this.getSpKeypair());
        signatureSigningParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        ((SecurityParametersContext)context.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signatureSigningParameters);
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(context);
        encoder.setHttpServletResponse(httpServletResponse);
        try {
            encoder.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new SAML2RuntimeException(e);
        }
        logger.info("Request: {}", requestForIDP.getClass());
        logger.info("Redirecting to IDP");
        try {
            encoder.encode();
        }
        catch (MessageEncodingException e) {
            throw new SAML2RuntimeException(e);
        }
    }

    Endpoint getIPDEndpoint() {
        SingleSignOnService endpoint = Helpers.buildSAMLObject(SingleSignOnService.class);
        endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        endpoint.setLocation(this.getSaml2IDPDestination());
        return endpoint;
    }

    Endpoint getSLOEndpoint() {
        SingleLogoutService endpoint = Helpers.buildSAMLObject(SingleLogoutService.class);
        endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
        endpoint.setLocation(this.getSaml2LogoutURL());
        return endpoint;
    }

    AuthnRequest buildAuthnRequest() {
        AuthnRequest authnRequest = Helpers.buildSAMLObject(AuthnRequest.class);
        authnRequest.setIssueInstant(Instant.now());
        authnRequest.setDestination(this.getSaml2IDPDestination());
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setAssertionConsumerServiceURL(this.getACSURL());
        authnRequest.setID(Helpers.generateSecureRandomId());
        authnRequest.setIssuer(this.buildIssuer());
        authnRequest.setNameIDPolicy(this.buildNameIdPolicy());
        return authnRequest;
    }

    Issuer buildIssuer() {
        Issuer issuer = Helpers.buildSAMLObject(Issuer.class);
        issuer.setValue(this.getEntityID());
        return issuer;
    }

    NameIDPolicy buildNameIdPolicy() {
        NameIDPolicy nameIDPolicy = Helpers.buildSAMLObject(NameIDPolicy.class);
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        return nameIDPolicy;
    }

    MessageContext decodeHttpPostSamlResp(HttpServletRequest request) {
        HTTPPostDecoder httpPostDecoder = new HTTPPostDecoder();
        ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();
        httpPostDecoder.setParserPool(parserPool);
        httpPostDecoder.setHttpServletRequest(request);
        try {
            httpPostDecoder.initialize();
            httpPostDecoder.decode();
            return httpPostDecoder.getMessageContext();
        }
        catch (MessageDecodingException e) {
            logger.error("MessageDecodingException");
            throw new SAML2RuntimeException(e);
        }
        catch (ComponentInitializationException e) {
            throw new SAML2RuntimeException(e);
        }
    }

    private Assertion decryptAssertion(EncryptedAssertion encryptedAssertion) {
        StaticKeyInfoCredentialResolver keyInfoCredentialResolver = new StaticKeyInfoCredentialResolver(this.getSpKeypair());
        Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyInfoCredentialResolver, (EncryptedKeyResolver)new InlineEncryptedKeyResolver());
        decrypter.setRootInNewDocument(true);
        try {
            return decrypter.decrypt(encryptedAssertion);
        }
        catch (DecryptionException e) {
            throw new SAML2RuntimeException(e);
        }
    }

    private void verifyAssertionSignature(Assertion assertion) {
        if (!assertion.isSigned()) {
            logger.error("Halting");
            throw new SAML2RuntimeException("The SAML Assertion was not signed!");
        }
        try {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            profileValidator.validate(assertion.getSignature());
            SignatureValidator.validate((Signature)assertion.getSignature(), (Credential)this.getIdpVerificationCert());
            logger.info("SAML Assertion signature verified");
        }
        catch (SignatureException e) {
            throw new SAML2RuntimeException("SAML Assertion signature problem", e);
        }
    }

    User doUserManagement(Assertion assertion) {
        if (assertion == null || assertion.getAttributeStatements().isEmpty() || ((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes().isEmpty()) {
            logger.warn("SAML Assertion Attribute Statement or Attributes was null ");
            return null;
        }
        Saml2User saml2User = new Saml2User();
        for (Attribute attribute : ((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes()) {
            if (attribute.getName().equals(this.getSaml2userIDAttr())) {
                this.setUserId(attribute, saml2User);
                continue;
            }
            if (attribute.getName().equals(this.getSaml2groupMembershipAttr())) {
                this.setGroupMembership(attribute, saml2User);
                continue;
            }
            if (this.getSyncAttrMap() == null || !this.getSyncAttrMap().containsKey(attribute.getName())) continue;
            this.syncUserAttributes(attribute, saml2User, this.getSyncAttrMap().get(attribute.getName()));
        }
        boolean setUpOk = this.saml2UserMgtService.setUp();
        if (setUpOk && saml2User != null && saml2User.getId() != null) {
            User samlUser = Objects.nonNull(this.getSaml2userHome()) && !this.getSaml2userHome().isEmpty() ? this.saml2UserMgtService.getOrCreateSamlUser(saml2User, this.getSaml2userHome()) : this.saml2UserMgtService.getOrCreateSamlUser(saml2User);
            this.saml2UserMgtService.updateGroupMembership(saml2User);
            this.saml2UserMgtService.updateUserProperties(saml2User);
            return samlUser;
        }
        if (saml2User != null && saml2User.getId() == null) {
            this.saml2UserMgtService.cleanUp();
            throw new SAML2RuntimeException("SAML2 User ID attribute name (saml2userIDAttr) is not correctly configured.");
        }
        this.saml2UserMgtService.cleanUp();
        return null;
    }

    private void setUserId(Attribute attribute, Saml2User saml2User) {
        logger.debug("username attr name: {}", (Object)attribute.getName());
        for (XMLObject attributeValue : attribute.getAttributeValues()) {
            if (((XSString)attributeValue).getValue() == null) continue;
            saml2User.setId(((XSString)attributeValue).getValue());
            logger.debug("username value: {}", (Object)saml2User.getId());
        }
    }

    private void setGroupMembership(Attribute attribute, Saml2User saml2User) {
        logger.debug("group attr name: {}", (Object)attribute.getName());
        for (XMLObject attributeValue : attribute.getAttributeValues()) {
            if (((XSString)attributeValue).getValue() == null) continue;
            saml2User.addGroupMembership(((XSString)attributeValue).getValue());
            logger.debug("managed group {} added: ", (Object)((XSString)attributeValue).getValue());
        }
    }

    private void syncUserAttributes(Attribute attribute, Saml2User saml2User, String propertyName) {
        for (XMLObject attributeValue : attribute.getAttributeValues()) {
            if (((XSString)attributeValue).getValue() == null) continue;
            saml2User.addUserProperty(propertyName, attributeValue);
            logger.debug("sync attr name: {}", (Object)propertyName);
            logger.debug("attribute value: {}", (Object)((XSString)attributeValue).getValue());
        }
    }

    AuthenticationInfo buildAuthInfo(User user) {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo(AUTH_TYPE, user.getID());
            authInfo.put("user.jcr.credentials", (Object)new Saml2Credentials(user.getID()));
            return authInfo;
        }
        catch (RepositoryException e) {
            logger.error("failed to build Authentication Info");
            throw new SAML2RuntimeException(e);
        }
    }

    AuthenticationInfo buildAuthInfo(String authData) {
        String userId = this.getUserId(authData);
        if (userId == null) {
            return null;
        }
        AuthenticationInfo info = new AuthenticationInfo(AUTH_TYPE, userId);
        info.put("user.jcr.credentials", (Object)new Saml2Credentials(userId));
        return info;
    }

    private void setRelayStateOnSession(HttpServletRequest req, SAMLBindingContext bindingContext) {
        String state = new BigInteger(130, new SecureRandom()).toString(32);
        bindingContext.setRelayState(state);
        SessionStorage sessionStorage = new SessionStorage(this.getSaml2SessionAttr());
        sessionStorage.setString(req, state);
    }

    private void setRequestIDOnSession(HttpServletRequest req, AuthnRequest authnRequest) {
        SessionStorage sessionStorage = new SessionStorage("saml2RequestID");
        sessionStorage.setString(req, authnRequest.getID());
    }

    private boolean validateRelayState(HttpServletRequest req, MessageContext messageContext) {
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
        String reportedRelayState = bindingContext.getRelayState();
        SessionStorage relayStateStore = new SessionStorage(this.getSaml2SessionAttr());
        String savedRelayState = relayStateStore.getString(req);
        if (savedRelayState == null || savedRelayState.isEmpty()) {
            return false;
        }
        return savedRelayState.equals(reportedRelayState);
    }

    private boolean validateSaml2Conditions(HttpServletRequest req, Assertion assertion) {
        String recipient;
        boolean validRecipient;
        List subjectConfirmations = assertion.getSubject().getSubjectConfirmations();
        if (subjectConfirmations.isEmpty()) {
            return false;
        }
        SubjectConfirmationData subjectConfirmationData = ((SubjectConfirmation)subjectConfirmations.get(0)).getSubjectConfirmationData();
        Instant notOnOrAfter = subjectConfirmationData.getNotOnOrAfter();
        boolean validTime = notOnOrAfter.isAfter(Instant.now());
        if (!validTime) {
            logger.error("SAML2 Subject Confirmation failed validation: Expired.");
        }
        if (!(validRecipient = (recipient = subjectConfirmationData.getRecipient()).equals(this.getACSURL()))) {
            logger.error("SAML2 Subject Confirmation failed validation: Invalid Recipient.");
        }
        String inResponseTo = subjectConfirmationData.getInResponseTo();
        String savedInResponseTo = new SessionStorage("saml2RequestID").getString(req);
        boolean validID = savedInResponseTo.equals(inResponseTo);
        return validTime && validRecipient && validID;
    }

    private void redirectToGotoURL(HttpServletRequest req, HttpServletResponse resp) {
        String gotoURL = (String)req.getSession().getAttribute("gotoURL");
        logger.info("Redirecting to requested URL: {}", (Object)gotoURL);
        try {
            resp.sendRedirect(gotoURL);
        }
        catch (IOException e) {
            throw new SAML2RuntimeException(e);
        }
    }

    public void dropCredentials(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.clearSessionAttributes(httpServletRequest);
        if (!this.getSaml2LogoutURL().isEmpty()) {
            httpServletResponse.sendRedirect(this.getSaml2LogoutURL());
        }
    }

    public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        this.clearSessionAttributes(request);
        request.setAttribute("j_reason", (Object)SamlReason.INVALID_CREDENTIALS);
    }

    public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        boolean result;
        this.refreshAuthData(request, response, authInfo);
        if (REQUEST_METHOD.equals(request.getMethod()) && request.getRequestURI().endsWith(this.getAcsPath())) {
            this.redirectToGotoURL(request, response);
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    void refreshAuthData(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        String token = this.getStorageAuthInfo().getString(request);
        boolean refreshCookie = this.needsRefresh(token);
        if (refreshCookie) {
            long expires = System.currentTimeMillis() + this.sessionTimeout;
            try {
                token = this.tokenStore.encode(expires, authInfo.getUser());
            }
            catch (UnsupportedEncodingException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw new SAML2RuntimeException(e);
            }
            if (token != null) {
                this.getStorageAuthInfo().setString(request, token);
            } else {
                this.clearSessionAttributes(request);
            }
        }
    }

    boolean needsRefresh(String authData) {
        boolean updateCookie = false;
        if (authData == null) {
            updateCookie = true;
        } else {
            String[] parts = TokenStore.split(authData);
            if (parts != null && parts.length == 3) {
                long cookieTime = Long.parseLong(parts[1].substring(1));
                long timeNow = System.currentTimeMillis();
                if (timeNow > cookieTime) {
                    updateCookie = true;
                }
            }
        }
        return updateCookie;
    }

    String getUserId(String authData) {
        String[] parts;
        if (authData != null && (parts = TokenStore.split(authData)) != null) {
            return parts[2];
        }
        return null;
    }

    File getTokenFile(BundleContext bundleContext) {
        File tokenFile = bundleContext.getDataFile(TOKEN_FILENAME);
        if (tokenFile == null) {
            String slingHome = bundleContext.getProperty("sling.home");
            tokenFile = slingHome != null ? new File(slingHome, TOKEN_FILENAME) : new File(TOKEN_FILENAME);
        }
        return tokenFile.getAbsoluteFile();
    }
}

