/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.override;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

class OverrideItem {
    private final String path;
    private final Pattern pathPattern;
    private final String configName;
    private final Map<String, Object> properties;
    private final boolean allProperties;

    public OverrideItem(String path, String configName, Map<String, Object> properties, boolean allProperties) {
        this.path = path;
        this.pathPattern = OverrideItem.toPathPattern(path);
        this.configName = configName;
        this.properties = properties;
        this.allProperties = allProperties;
    }

    private static Pattern toPathPattern(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        return Pattern.compile("^" + Pattern.quote(StringUtils.trim((String)path)) + "(/.*)?$");
    }

    public String getPath() {
        return this.path;
    }

    public boolean matchesPath(String path) {
        if (this.pathPattern == null) {
            return true;
        }
        return this.pathPattern.matcher(path).matches();
    }

    public String getConfigName() {
        return this.configName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean isAllProperties() {
        return this.allProperties;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

