/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.clam.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.sling.commons.clam.ClamService;
import org.apache.sling.commons.clam.ScanResult;
import org.apache.sling.commons.clam.internal.ClamdServiceConfiguration;
import org.apache.sling.commons.clam.internal.InstreamSizeLimitExceededException;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Sling Commons Clamd Service", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=ClamdServiceConfiguration.class)
public class ClamdService
implements ClamService {
    private ClamdServiceConfiguration configuration;
    private static final byte[] PING_COMMAND = "nPING\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] PONG_REPLY = "PONG\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] INSTREAM_COMMAND = "nINSTREAM\n".getBytes(StandardCharsets.US_ASCII);
    private static final String OK_REPLY_PATTERN = "stream: OK";
    private static final String FOUND_REPLY_PATTERN = "stream: .+ FOUND";
    private static final String INSTREAM_SIZE_LIMIT_EXCEEDED_PATTERN = "INSTREAM size limit exceeded. ERROR";
    private final Logger logger = LoggerFactory.getLogger(ClamdService.class);

    @Activate
    private void activate(ClamdServiceConfiguration configuration) {
        this.logger.debug("activating");
        this.configure(configuration);
    }

    @Modified
    private void modified(ClamdServiceConfiguration configuration) {
        this.logger.debug("modifying");
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
    }

    private void configure(ClamdServiceConfiguration configuration) {
        this.configuration = configuration;
        this.playPingPong();
    }

    @Override
    @NotNull
    public ScanResult scan(@NotNull InputStream inputStream) throws IOException {
        try {
            return this.doInstream(inputStream);
        }
        catch (InstreamSizeLimitExceededException e) {
            this.logger.error("doing INSTREAM failed", (Throwable)e);
            return new ScanResult(ScanResult.Status.ERROR, e.getMessage(), e.getStarted(), e.getSize());
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] doPing() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void playPingPong() {
        try {
            byte[] reply = this.doPing();
            if (Arrays.equals(reply, PONG_REPLY)) {
                this.logger.info("clam daemon replied with PONG");
            } else {
                String message = new String(reply, StandardCharsets.US_ASCII);
                this.logger.error("clam daemon replied with unknown message: {}", (Object)message);
            }
        }
        catch (IOException e) {
            this.logger.error("pinging clam daemon failed: {}", (Object)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private ScanResult doInstream(InputStream inputStream) throws IOException, InstreamSizeLimitExceededException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ScanResult parseClamdReply(byte[] reply, long started, long size) {
        String message = new String(reply, StandardCharsets.US_ASCII).trim();
        this.logger.info("reply message from clam daemon: '{}'", (Object)message);
        if (message.matches(OK_REPLY_PATTERN)) {
            return new ScanResult(ScanResult.Status.OK, message, started, size);
        }
        if (message.matches(FOUND_REPLY_PATTERN)) {
            return new ScanResult(ScanResult.Status.FOUND, message, started, size);
        }
        if (message.matches(INSTREAM_SIZE_LIMIT_EXCEEDED_PATTERN)) {
            return new ScanResult(ScanResult.Status.ERROR, message, started, size);
        }
        return new ScanResult(ScanResult.Status.UNKNOWN, message, started, size);
    }
}

