/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.metrics.internal;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.felix.utils.json.JSONWriter;

class JSONReporter
implements Reporter,
Closeable {
    private final MetricRegistry registry;
    private final MetricFilter filter;
    private final double durationFactor;
    private final String durationUnit;
    private final double rateFactor;
    private final String rateUnit;
    private final JSONWriter json;
    private final PrintWriter pw;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private JSONReporter(MetricRegistry registry, PrintStream output, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        this.registry = registry;
        this.filter = filter;
        this.pw = new PrintWriter(output);
        this.json = new JSONWriter(this.pw);
        this.rateFactor = rateUnit.toSeconds(1L);
        this.rateUnit = JSONReporter.calculateRateUnit(rateUnit);
        this.durationFactor = 1.0 / (double)durationUnit.toNanos(1L);
        this.durationUnit = durationUnit.toString().toLowerCase(Locale.US);
    }

    public void report() {
        try {
            this.report(this.registry.getGauges(this.filter), this.registry.getCounters(this.filter), this.registry.getHistograms(this.filter), this.registry.getMeters(this.filter), this.registry.getTimers(this.filter));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.pw.flush();
    }

    private void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) throws IOException {
        this.json.object();
        if (!gauges.isEmpty()) {
            this.json.key("gauges").object();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.printGauge(entry);
            }
            this.json.endObject();
        }
        if (!counters.isEmpty()) {
            this.json.key("counters").object();
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.printCounter(entry);
            }
            this.json.endObject();
        }
        if (!histograms.isEmpty()) {
            this.json.key("histograms").object();
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.printHistogram(entry);
            }
            this.json.endObject();
        }
        if (!meters.isEmpty()) {
            this.json.key("meters").object();
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.printMeter(entry);
            }
            this.json.endObject();
        }
        if (!timers.isEmpty()) {
            this.json.key("timers").object();
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.printTimer(entry);
            }
            this.json.endObject();
        }
        this.json.endObject();
    }

    private void printTimer(Map.Entry<String, Timer> e) throws IOException {
        this.json.key(e.getKey()).object();
        Timer timer = e.getValue();
        Snapshot snapshot = timer.getSnapshot();
        this.json.key("count").value(timer.getCount());
        this.json.key("max").value((double)snapshot.getMax() * this.durationFactor);
        this.json.key("mean").value(snapshot.getMean() * this.durationFactor);
        this.json.key("min").value((double)snapshot.getMin() * this.durationFactor);
        this.json.key("p50").value(snapshot.getMedian() * this.durationFactor);
        this.json.key("p75").value(snapshot.get75thPercentile() * this.durationFactor);
        this.json.key("p95").value(snapshot.get95thPercentile() * this.durationFactor);
        this.json.key("p98").value(snapshot.get98thPercentile() * this.durationFactor);
        this.json.key("p99").value(snapshot.get99thPercentile() * this.durationFactor);
        this.json.key("p999").value(snapshot.get999thPercentile() * this.durationFactor);
        this.json.key("stddev").value(snapshot.getStdDev() * this.durationFactor);
        this.json.key("m1_rate").value(timer.getOneMinuteRate() * this.rateFactor);
        this.json.key("m5_rate").value(timer.getFiveMinuteRate() * this.rateFactor);
        this.json.key("m15_rate").value(timer.getFifteenMinuteRate() * this.rateFactor);
        this.json.key("mean_rate").value(timer.getMeanRate() * this.rateFactor);
        this.json.key("duration_units").value(this.durationUnit);
        this.json.key("rate_units").value(this.rateUnit);
        this.json.endObject();
    }

    private void printMeter(Map.Entry<String, Meter> e) throws IOException {
        this.json.key(e.getKey()).object();
        Meter meter = e.getValue();
        this.json.key("count").value(e.getValue().getCount());
        this.json.key("m1_rate").value(meter.getOneMinuteRate() * this.rateFactor);
        this.json.key("m5_rate").value(meter.getFiveMinuteRate() * this.rateFactor);
        this.json.key("m15_rate").value(meter.getFifteenMinuteRate() * this.rateFactor);
        this.json.key("mean_rate").value(meter.getMeanRate() * this.rateFactor);
        this.json.key("units").value(this.rateUnit);
        this.json.endObject();
    }

    private void printHistogram(Map.Entry<String, Histogram> e) throws IOException {
        this.json.key(e.getKey()).object();
        this.json.key("count").value(e.getValue().getCount());
        Snapshot snapshot = e.getValue().getSnapshot();
        this.json.key("max").value(snapshot.getMax());
        this.json.key("mean").value(snapshot.getMean());
        this.json.key("min").value(snapshot.getMin());
        this.json.key("p50").value(snapshot.getMedian());
        this.json.key("p75").value(snapshot.get75thPercentile());
        this.json.key("p95").value(snapshot.get95thPercentile());
        this.json.key("p98").value(snapshot.get98thPercentile());
        this.json.key("p99").value(snapshot.get99thPercentile());
        this.json.key("p999").value(snapshot.get999thPercentile());
        this.json.key("stddev").value(snapshot.getStdDev());
        this.json.endObject();
    }

    private void printCounter(Map.Entry<String, Counter> e) throws IOException {
        this.json.key(e.getKey()).object();
        this.json.key("count").value(e.getValue().getCount());
        this.json.endObject();
    }

    private void printGauge(Map.Entry<String, Gauge> e) throws IOException {
        this.json.key(e.getKey()).object();
        Object v = e.getValue().getValue();
        this.json.key("value").value(JSONReporter.jsonSafeValue(v));
        this.json.endObject();
    }

    private static Object jsonSafeValue(Object v) {
        Double d;
        if (v instanceof Number && v instanceof Double && ((d = (Double)v).isInfinite() || d.isNaN())) {
            return d.toString();
        }
        return v;
    }

    private static String calculateRateUnit(TimeUnit unit) {
        String s = unit.toString().toLowerCase(Locale.US);
        return s.substring(0, s.length() - 1);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private PrintStream output;
        private MetricFilter filter;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.output = System.out;
            this.filter = MetricFilter.ALL;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
        }

        public Builder outputTo(PrintStream output) {
            this.output = output;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public JSONReporter build() {
            return new JSONReporter(this.registry, this.output, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

