/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.core.commands;

import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.osgi.framework.launch.FrameworkFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartFramework
implements CrankstartCommand {
    public static final String I_START_FRAMEWORK = "start.framework";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String EXIT_IF_NOT_FIRST = "exitIfNotFirstStartup";

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return I_START_FRAMEWORK.equals(commandLine.getVerb());
    }

    public String getDescription() {
        return "start.framework: start the OSGi framework";
    }

    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine commandLine) throws Exception {
        FrameworkFactory frameworkFactory = (FrameworkFactory)this.getClass().getClassLoader().loadClass("org.apache.felix.framework.FrameworkFactory").newInstance();
        crankstartContext.setOsgiFramework(frameworkFactory.newFramework(crankstartContext.getOsgiFrameworkProperties()));
        crankstartContext.getOsgiFramework().start();
        int nBundles = crankstartContext.getOsgiFramework().getBundleContext().getBundles().length;
        this.log.info("OSGi framework started, {} bundles installed", (Object)nBundles);
        if (this.stopProcessing(commandLine, nBundles)) {
            crankstartContext.setAttribute("crankstart.stop.processing", (Object)true);
        }
    }

    boolean stopProcessing(CrankstartCommandLine cmd, int nBundles) {
        boolean doNotExit;
        boolean result = false;
        Object exitSetting = cmd.getProperties().get(EXIT_IF_NOT_FIRST);
        boolean bl = doNotExit = exitSetting != null && !"true".equals(exitSetting);
        if (nBundles <= 0) {
            throw new IllegalArgumentException("Expecting at least one installed bundle after startup");
        }
        if (doNotExit) {
            this.log.info("{}={}, will continue processing the crankstart file although this is not the first startup", (Object)EXIT_IF_NOT_FIRST, exitSetting);
        } else if (nBundles == 1) {
            this.log.info("Only {} bundle installed after framework startup, processing the full crankstart file", (Object)nBundles);
        } else {
            result = true;
            this.log.info("{} bundles installed, ignoring the rest of the crankstart file (set {}=false in this command's properties to disable this feature)", (Object)nBundles, (Object)EXIT_IF_NOT_FIRST);
        }
        return result;
    }
}

