/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.handler.media.MediaArgs;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WidthUtils {
    static final Pattern WIDTHS_PATTERN = Pattern.compile("^\\s*\\d+\\??\\s*(,\\s*\\d+\\??\\s*)*$");

    private WidthUtils() {
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    public static @NotNull MediaArgs.WidthOption @Nullable [] parseWidths(@Nullable String widths) {
        if (StringUtils.isBlank((CharSequence)widths)) {
            return null;
        }
        if (!WIDTHS_PATTERN.matcher(widths).matches()) {
            return null;
        }
        String[] widthItems = StringUtils.split((String)widths, (String)",");
        return (MediaArgs.WidthOption[])Arrays.stream(widthItems).map(StringUtils::trim).map(WidthUtils::toWidthOption).toArray(MediaArgs.WidthOption[]::new);
    }

    @NotNull
    private static MediaArgs.WidthOption toWidthOption(String width) {
        boolean optional = StringUtils.endsWith((CharSequence)width, (CharSequence)"?");
        String widthValue = optional ? StringUtils.substringBefore((String)width, (String)"?") : width;
        return new MediaArgs.WidthOption(NumberUtils.toLong((String)widthValue), !optional);
    }
}

