/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.accesscontrol;

import java.util.Objects;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractUser {
    private final String id;
    private final RepoPath path;
    private final RepoPath intermediatePath;
    private final String disabledReason;

    protected AbstractUser(@NotNull String id, @NotNull RepoPath path, @NotNull RepoPath intermediatePath) {
        this(id, path, intermediatePath, null);
    }

    protected AbstractUser(@NotNull String id, @NotNull RepoPath path, @NotNull RepoPath intermediatePath, @Nullable String disabledReason) {
        this.id = id;
        this.path = path;
        this.intermediatePath = intermediatePath;
        this.disabledReason = disabledReason;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public RepoPath getPath() {
        return this.path;
    }

    @NotNull
    public RepoPath getIntermediatePath() {
        return this.intermediatePath;
    }

    @Nullable
    public String getDisabledReason() {
        return this.disabledReason;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.id);
        result = 31 * result + Objects.hash(this.path);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractUser other = (AbstractUser)obj;
        return Objects.equals(this.id, other.getId()) && Objects.equals(this.path, other.getPath());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + ", path=" + this.path + "]";
    }
}

