/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.compiler.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilationUnit;
import org.apache.sling.commons.compiler.CompilerMessage;
import org.apache.sling.commons.compiler.JavaCompiler;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.compiler.JcrJavaCompiler;

public class JcrJavaCompilerImpl
implements JcrJavaCompiler {
    protected JavaCompiler compiler;
    protected SlingRepository repository;

    public CompilationResult compile(String[] srcFiles, String outputDir, Options compilerOptions) throws Exception {
        return this.compile(srcFiles, compilerOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilationResult compile(String[] srcFiles, Options compilerOptions) throws Exception {
        Options options = compilerOptions == null ? new Options() : new Options(compilerOptions);
        Session session = null;
        try {
            session = this.repository.loginAdministrative(null);
            CompilationUnit[] units = new CompilationUnit[srcFiles.length];
            for (int i = 0; i < units.length; ++i) {
                units[i] = this.createCompileUnit(srcFiles[i], session);
            }
            CompilationResult compilationResult = this.mapResult(this.compiler.compile(units, options), srcFiles, units);
            return compilationResult;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private CompilationResult mapResult(final CompilationResult result, String[] srcFiles, CompilationUnit[] units) {
        if (result == null || result.getErrors() == null && result.getWarnings() == null) {
            return result;
        }
        final HashMap<String, String> mapping = new HashMap<String, String>();
        for (int i = 0; i < srcFiles.length; ++i) {
            mapping.put(units[i].getMainClassName() + ".java", srcFiles[i]);
        }
        return new CompilationResult(){

            private List<CompilerMessage> mapMessages(List<CompilerMessage> msgs) {
                if (msgs == null || msgs.size() == 0) {
                    return msgs;
                }
                ArrayList<CompilerMessage> newMsgs = new ArrayList<CompilerMessage>();
                for (CompilerMessage msg : msgs) {
                    String mapped = (String)mapping.get(msg.getFile());
                    newMsgs.add(new CompilerMessage(mapped == null ? msg.getFile() : mapped, msg.getLine(), msg.getColumn(), msg.getMessage()));
                }
                return newMsgs;
            }

            public Class<?> loadCompiledClass(String className) throws ClassNotFoundException {
                return result.loadCompiledClass(className);
            }

            public List<CompilerMessage> getWarnings() {
                return this.mapMessages(result.getWarnings());
            }

            public List<CompilerMessage> getErrors() {
                return this.mapMessages(result.getErrors());
            }

            public boolean didCompile() {
                return result.didCompile();
            }
        };
    }

    private CompilationUnit createCompileUnit(final String sourceFile, Session session) throws RepositoryException, IOException {
        final Source source = this.readTextResource(sourceFile, session);
        final String packageName = this.extractPackageName(source.contents);
        return new CompilationUnit(){

            public String getMainClassName() {
                return packageName + '.' + this.getMainTypeName();
            }

            public Reader getSource() throws IOException {
                return new StringReader(source.contents);
            }

            public long getLastModified() {
                return source.lastModified;
            }

            private String getMainTypeName() {
                int pos = sourceFile.lastIndexOf(".java");
                String className = pos != -1 ? sourceFile.substring(0, pos).trim() : sourceFile.trim();
                pos = className.lastIndexOf(47);
                return pos == -1 ? className : className.substring(pos + 1);
            }
        };
    }

    private String extractPackageName(String contents) {
        BufferedReader reader = new BufferedReader(new StringReader(contents));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("package")) continue;
                line = line.substring("package".length());
                line = line.substring(0, line.lastIndexOf(59));
                return line.trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source readTextResource(String resourcePath, Session session) throws RepositoryException, IOException {
        Source source = new Source();
        String relPropPath = resourcePath.substring(1) + "/jcr:content/jcr:data";
        InputStream in = session.getRootNode().getProperty(relPropPath).getStream();
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        StringWriter writer = new StringWriter();
        try {
            char[] buffer = new char[2048];
            int read = 0;
            while ((read = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, read);
            }
            writer.close();
            source.contents = writer.toString();
            String lastModPath = resourcePath + "/jcr:content/jcr:lastModified";
            source.lastModified = session.itemExists(lastModPath) ? ((Property)session.getItem(lastModPath)).getLong() : -1L;
            Source source2 = source;
            return source2;
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException ignore) {}
        }
    }

    protected void bindCompiler(JavaCompiler javaCompiler) {
        this.compiler = javaCompiler;
    }

    protected void unbindCompiler(JavaCompiler javaCompiler) {
        if (this.compiler == javaCompiler) {
            this.compiler = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    private static final class Source {
        public String contents;
        public long lastModified;

        private Source() {
        }
    }
}

