/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.check.ReportItem;
import org.apache.jackrabbit.core.persistence.check.ReportItemImpl;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;

abstract class ConsistencyCheckerError {
    protected final String message;
    protected final NodeId nodeId;
    protected boolean repaired;

    ConsistencyCheckerError(NodeId nodeId, String message) {
        this.nodeId = nodeId;
        this.message = message;
    }

    final NodeId getNodeId() {
        return this.nodeId;
    }

    final void repair(ChangeLog changes) throws ItemStateException {
        this.doRepair(changes);
        this.repaired = true;
    }

    final ReportItem getReportItem() {
        return new ReportItemImpl(this.nodeId.toString(), this.message, this.getType(), this.repaired);
    }

    abstract boolean isRepairable();

    abstract void doRepair(ChangeLog var1) throws ItemStateException;

    abstract ReportItem.Type getType();

    abstract boolean doubleCheck() throws ItemStateException;

    public String toString() {
        return (Object)((Object)this.getType()) + " - " + this.getNodeId();
    }
}

