/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.performance;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.performance.FrameworkPerformanceMethod;
import org.apache.sling.performance.ParameterizedTestList;
import org.apache.sling.performance.PerformanceSuiteState;
import org.apache.sling.performance.ReportLogger;
import org.apache.sling.performance.annotation.AfterSuite;
import org.apache.sling.performance.annotation.BeforeSuite;
import org.apache.sling.performance.annotation.PerformanceTest;
import org.apache.sling.performance.annotation.PerformanceTestFactory;
import org.apache.sling.performance.annotation.PerformanceTestSuite;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(ReportLogger.class);
    protected LinkedList<FrameworkMethod> tests = new LinkedList();
    private List<PerformanceSuiteState> suitesState = new ArrayList<PerformanceSuiteState>();
    public ReportLevel reportLevel = ReportLevel.ClassLevel;
    public String referenceMethod = null;

    public PerformanceRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        if (clazz.getAnnotation(Parameters.class) != null) {
            this.reportLevel = clazz.getAnnotation(Parameters.class).reportLevel();
            this.referenceMethod = clazz.getAnnotation(Parameters.class).referenceMethod();
            if ("".equals(this.referenceMethod)) {
                this.referenceMethod = null;
            } else {
                boolean found = false;
                for (Method method : clazz.getMethods()) {
                    if (!method.getName().equals(this.referenceMethod) || method.getParameterTypes().length != 0) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.referenceMethod = null;
                }
            }
        }
        try {
            this.computeTests();
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        try {
            ReportLogger.writeAllResults();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            for (Failure failure : ReportLogger.checkAllThresholds()) {
                notifier.fireTestFailure(failure);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void computeTests() throws Exception {
        this.tests.addAll(super.computeTestMethods());
        this.tests.addAll(this.computePerformanceTests());
        this.createTest();
    }

    protected Collection<? extends FrameworkMethod> computePerformanceTests() throws Exception {
        LinkedList<FrameworkPerformanceMethod> tests = new LinkedList<FrameworkPerformanceMethod>();
        ArrayList<Object> testObjects = new ArrayList<Object>();
        List<Object> testObjectsTmp = new ArrayList();
        ParameterizedTestList testCenter = new ParameterizedTestList();
        for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(PerformanceTestSuite.class)) {
            Object targetObject = this.getTestClass().getJavaClass().newInstance();
            if (method.getMethod().getReturnType().equals(ParameterizedTestList.class)) {
                testCenter = (ParameterizedTestList)method.getMethod().invoke(targetObject, new Object[0]);
                testObjectsTmp = testCenter.getTestObjectList();
                for (Object testObject : testObjectsTmp) {
                    Method[] factoryMethods = this.getSpecificMethods(testObject.getClass(), PerformanceTestFactory.class);
                    if (factoryMethods.length > 0) {
                        if (factoryMethods.length > 1) {
                            throw new IllegalStateException("There should be at most one PerformanceTestFactory method");
                        }
                        Method method2 = factoryMethods[0];
                        List<Object> instances = method2.invoke(testObject, new Object[0]);
                        if (instances.getClass().isArray()) {
                            instances = Arrays.asList((Object[])instances);
                        }
                        if (!(instances instanceof Iterable)) {
                            instances = Collections.singletonList(instances);
                        }
                        testObjects.addAll(instances);
                        continue;
                    }
                    testObjects.add(testObject);
                }
                continue;
            }
            throw new InitializationError("Wrong signature for the @PerformanceTestSuite method");
        }
        List beforeSuiteMethods = this.getTestClass().getAnnotatedMethods(BeforeSuite.class);
        if (beforeSuiteMethods.size() > 1) {
            throw new InitializationError("Only one @BeforeSuite method is allowed for a @PerformanceSuite");
        }
        List afterSuiteMethods = this.getTestClass().getAnnotatedMethods(AfterSuite.class);
        if (afterSuiteMethods.size() > 1) {
            throw new InitializationError("Only one @AfterSuite method is allowed for a @PerformanceSuite");
        }
        PerformanceSuiteState current = null;
        boolean suiteAlreadyRegistered = false;
        for (PerformanceSuiteState suiteState : this.suitesState) {
            if (!suiteState.testSuiteName.equals(testCenter.getTestSuiteName())) continue;
            suiteAlreadyRegistered = true;
            suiteState.incrementNumberOfTestMethodsInSuite();
            current = suiteState;
            break;
        }
        PerformanceSuiteState newSuite = new PerformanceSuiteState(testCenter.getTestSuiteName());
        if (!suiteAlreadyRegistered) {
            if (beforeSuiteMethods.size() == 1) {
                newSuite.setBeforeSuiteMethod(((FrameworkMethod)beforeSuiteMethods.get(0)).getMethod());
            }
            if (afterSuiteMethods.size() == 1) {
                newSuite.setAfterSuiteMethod(((FrameworkMethod)afterSuiteMethods.get(0)).getMethod());
            }
            current = newSuite;
            newSuite.setTargetObjectSuite(this.getTestClass().getJavaClass().newInstance());
        }
        if (!testObjects.isEmpty()) {
            for (Object e : testObjects) {
                Method[] testMethods;
                for (Method method : testMethods = this.getSpecificMethods(e.getClass(), PerformanceTest.class)) {
                    FrameworkPerformanceMethod performaceTestMethod = new FrameworkPerformanceMethod(method, e, current, this.reportLevel, this.referenceMethod);
                    tests.add(performaceTestMethod);
                }
                if (suiteAlreadyRegistered) continue;
                newSuite.incrementNumberOfTestMethodsInSuite();
            }
            this.suitesState.add(newSuite);
        }
        for (FrameworkMethod frameworkMethod : this.getTestClass().getAnnotatedMethods(PerformanceTest.class)) {
            Object targetObject = this.getTestClass().getJavaClass().newInstance();
            FrameworkPerformanceMethod performanceTestMethod = new FrameworkPerformanceMethod(frameworkMethod.getMethod(), targetObject, current, this.reportLevel, this.referenceMethod);
            tests.add(performanceTestMethod);
        }
        return tests;
    }

    private Method[] getSpecificMethods(Class testClass, Class<? extends Annotation> annotation) {
        Method[] allMethods = testClass.getDeclaredMethods();
        ArrayList<Method> methodListResult = new ArrayList<Method>();
        for (Method testMethod : allMethods) {
            if (!testMethod.isAnnotationPresent(annotation)) continue;
            methodListResult.add(testMethod);
        }
        return methodListResult.toArray(new Method[0]);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.tests;
    }

    protected void validateInstanceMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(After.class, false, errors);
        this.validatePublicVoidNoArgMethods(Before.class, false, errors);
        this.validateTestMethods(errors);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Parameters {
        public ReportLevel reportLevel() default ReportLevel.ClassLevel;

        public String referenceMethod() default "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportLevel {
        ClassLevel,
        MethodLevel;

    }
}

