/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SuperPipe
extends BasePipe {
    private static final Logger LOG = LoggerFactory.getLogger(SuperPipe.class);
    public static final String PN_SLEEP = "sleep";
    protected long sleep = 0L;
    protected List<Pipe> subpipes = new ArrayList<Pipe>();

    public SuperPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
        this.sleep = (Long)this.properties.get(PN_SLEEP, (Object)0L);
    }

    public abstract void buildChildren();

    protected abstract Iterator<Resource> computeSubpipesOutput();

    @Override
    protected Iterator<Resource> computeOutput() {
        if (this.subpipes.isEmpty()) {
            this.buildChildren();
        }
        return this.computeSubpipesOutput();
    }

    protected Pipe getFirstPipe() {
        return !this.subpipes.isEmpty() ? this.subpipes.get(0) : null;
    }

    protected Pipe getLastPipe() {
        return !this.subpipes.isEmpty() ? this.subpipes.get(this.subpipes.size() - 1) : null;
    }

    public Pipe getPreviousPipe(Pipe pipe) {
        Pipe previousPipe = null;
        if (!this.subpipes.isEmpty()) {
            if (this.subpipes.get(0).equals(pipe) && this.parent != null) {
                return this.parent.getPreviousPipe(this);
            }
            for (Pipe candidate : this.subpipes) {
                if (candidate.equals(pipe)) {
                    return previousPipe;
                }
                previousPipe = candidate;
            }
        }
        return null;
    }

    @Override
    public boolean modifiesContent() {
        try {
            if (this.subpipes.isEmpty()) {
                this.buildChildren();
            }
            for (Pipe pipe : this.subpipes) {
                if (!pipe.modifiesContent()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOG.error("something went wrong while building this pipe, we'll consider this pipe as modifying content", (Throwable)e);
            return true;
        }
    }

    @Override
    public void before() {
        LOG.debug("entering {} before", (Object)this.getName());
        super.before();
        if (this.subpipes.isEmpty()) {
            this.buildChildren();
        }
        for (Pipe pipe : this.subpipes) {
            LOG.debug("calling {} before", (Object)this.getName());
            pipe.before();
        }
    }

    @Override
    public void after() {
        LOG.debug("entering {} after", (Object)this.getName());
        super.after();
        for (Pipe pipe : this.subpipes) {
            LOG.debug("calling {} after", (Object)pipe.getName());
            pipe.after();
        }
    }
}

