/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.mapping.ResourceMapper;
import org.apache.sling.api.resource.runtime.RuntimeService;
import org.apache.sling.api.resource.runtime.dto.ResourceProviderDTO;
import org.apache.sling.api.resource.runtime.dto.RuntimeDTO;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.helper.URI;
import org.apache.sling.resourceresolver.impl.helper.URIException;
import org.apache.sling.resourceresolver.impl.mapping.MapEntriesHandler;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ResourceResolverWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private static final String ATTR_TEST = "plugin.test";
    private static final String ATTR_SUBMIT = "plugin.submit";
    private static final String PAR_MSG = "msg";
    private static final String PAR_TEST = "test";
    private final transient CommonResourceResolverFactoryImpl resolverFactory;
    private transient ServiceRegistration<Servlet> service;
    private final transient RuntimeService runtimeService;
    private final transient BundleContext bundleContext;

    public ResourceResolverWebConsolePlugin(BundleContext context, CommonResourceResolverFactoryImpl resolverFactory, RuntimeService runtimeService) {
        this.resolverFactory = resolverFactory;
        this.runtimeService = runtimeService;
        this.bundleContext = context;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling Resource Resolver Web Console Plugin");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("service.pid", ((Object)((Object)this)).getClass().getName());
        ((Dictionary)props).put("felix.webconsole.label", "jcrresolver");
        ((Dictionary)props).put("felix.webconsole.title", "Resource Resolver");
        ((Dictionary)props).put("felix.webconsole.css", "/jcrresolver/res/ui/resourceresolver.css");
        ((Dictionary)props).put("felix.webconsole.category", "Sling");
        ((Dictionary)props).put("felix.webconsole.configprinter.modes", "always");
        this.service = context.registerService(Servlet.class, (Object)this, props);
    }

    public void dispose() {
        if (this.service != null) {
            this.service.unregister();
            this.service = null;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String msg = request.getParameter(PAR_MSG);
        String test = msg != null ? request.getParameter(PAR_TEST) : null;
        PrintWriter pw = response.getWriter();
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        MapEntriesHandler mapEntries = this.resolverFactory.getMapEntries();
        this.titleHtml(pw, "Configuration", null);
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Resource Search Path</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print(Arrays.asList(this.resolverFactory.getSearchPath()).toString());
        pw.print("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Namespace Mangling</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print(this.resolverFactory.isMangleNamespacePrefixes() ? "Enabled" : "Disabled");
        pw.print("</td>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Mapping Location</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print(this.resolverFactory.getMapRoot());
        pw.print("</td>");
        pw.println("</tr>");
        this.separatorHtml(pw);
        this.titleHtml(pw, "Configuration Test", "To test the configuration, enter an URL or a resource path into the field and click 'Resolve' to resolve the URL or click 'Map' to map the resource path. To simulate a map call that takes the current request into account, provide a full URL whose scheme/host/port prefix will then be used as the request information. The path passed to map will always be the path part of the URL. In case multiple mapping candidates are found, the primary one, which would be returned by ResourceResolver.map, is clearly marked, and the others listed for completeness.");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>Test</td>");
        pw.print("<td class='content' colspan='2'>");
        pw.print("<form method='post'>");
        pw.print("<input type='text' name='plugin.test' value='");
        if (test != null) {
            pw.print(ResponseUtil.escapeXml((String)test));
        }
        pw.println("' class='input' size='50'>");
        pw.println("&nbsp;&nbsp;<input type='submit' name='plugin.submit' value='Resolve' class='submit'>");
        pw.println("&nbsp;&nbsp;<input type='submit' name='plugin.submit' value='Map' class='submit'>");
        pw.print("</form>");
        pw.print("</td>");
        pw.println("</tr>");
        if (msg != null) {
            pw.println("<tr class='content'>");
            pw.println("<td class='content'>&nbsp;</td>");
            pw.print("<td class='content' colspan='2'>");
            pw.print(ResponseUtil.escapeXml((String)msg));
            pw.println("</td>");
            pw.println("</tr>");
        }
        this.separatorHtml(pw);
        this.dumpMapHtml(pw, "Resolver Map Entries", "Lists the entries used by the ResourceResolver.resolve methods to map URLs to Resources", mapEntries.getResolveMaps());
        this.separatorHtml(pw);
        this.dumpMapHtml(pw, "Mapping Map Entries", "Lists the entries used by the ResourceResolver.map methods to map Resource Paths to URLs", mapEntries.getMapMaps());
        this.separatorHtml(pw);
        this.dumpDTOsHtml(pw);
        pw.println("</table>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String test = request.getParameter(ATTR_TEST);
        Object msg = null;
        if (test != null && test.length() > 0) {
            try (ResourceResolver resolver = null;){
                Object result;
                ResolverRequest helper = new ResolverRequest(request, test);
                resolver = this.resolverFactory.getServiceResourceResolver(this.resolverFactory.getServiceUserAuthenticationInfo("console"));
                if ("Map".equals(request.getParameter(ATTR_SUBMIT))) {
                    ResourceMapper mapper = (ResourceMapper)resolver.adaptTo(ResourceMapper.class);
                    result = helper.getServerName() == null ? ResourceResolverWebConsolePlugin.mappingsToString(mapper.getAllMappings(helper.getPathInfo())) : ResourceResolverWebConsolePlugin.mappingsToString(mapper.getAllMappings(helper.getPathInfo(), (HttpServletRequest)helper));
                } else {
                    result = resolver.resolve((HttpServletRequest)helper, helper.getPathInfo());
                }
                msg = result.toString();
            }
        }
        String path = request.getContextPath() + request.getServletPath() + request.getPathInfo();
        String redirectTo = msg == null ? path : path + "?msg=" + this.encodeParam((String)msg) + "&test=" + this.encodeParam(test);
        response.sendRedirect(redirectTo);
    }

    private static String mappingsToString(Collection<String> allMappings) {
        if (allMappings.size() == 0) {
            return "";
        }
        if (allMappings.size() == 1) {
            return allMappings.iterator().next();
        }
        StringBuilder out = new StringBuilder();
        Iterator<String> it = allMappings.iterator();
        while (it.hasNext()) {
            if (out.length() == 0) {
                out.append("Primary: ").append(it.next());
                if (!it.hasNext()) continue;
                out.append(". Other candidates:");
                continue;
            }
            out.append(' ').append(it.next()).append(',');
        }
        out.setCharAt(out.length() - 1, '.');
        return out.toString();
    }

    private String encodeParam(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public void printConfiguration(PrintWriter pw) {
        this.dumpDTOsText(pw);
        this.separatorText(pw);
        MapEntriesHandler mapEntries = this.resolverFactory.getMapEntries();
        this.dumpMapText(pw, "Resolver Map Entries", mapEntries.getResolveMaps());
        this.separatorText(pw);
        this.dumpMapText(pw, "Mapping Map Entries", mapEntries.getMapMaps());
    }

    private void dumpMapHtml(PrintWriter pw, String title, String description, Collection<MapEntry> list) {
        this.titleHtml(pw, title, description);
        pw.println("<tr class='content'>");
        pw.println("<th class='content'>Pattern</th>");
        pw.println("<th class='content'>Replacement</th>");
        pw.println("<th class='content'>Redirect</th>");
        pw.println("</tr>");
        HashSet<String> usedPatterns = new HashSet<String>();
        for (MapEntry entry : list) {
            String[] repls;
            String pattern = entry.getPattern();
            pw.print("<tr class='content");
            if (!usedPatterns.add(pattern)) {
                pw.print(" duplicate");
            }
            pw.println("'>");
            pw.println("<td class='content' style='vertical-align: top'>");
            pw.print(ResponseUtil.escapeXml((String)pattern));
            pw.print("</td>");
            pw.print("<td class='content' style='vertical-align: top'>");
            for (String repl : repls = entry.getRedirect()) {
                pw.print(ResponseUtil.escapeXml((String)repl));
                pw.print("<br/>");
            }
            pw.print("</td>");
            pw.print("<td class='content' style='vertical-align: top'>");
            if (entry.isInternal()) {
                pw.print("internal");
            } else {
                pw.print("external: ");
                pw.print(String.valueOf(entry.getStatus()));
            }
            pw.println("</td></tr>");
        }
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        pw.print("<tr class='content'>");
        pw.print("<th colspan='3'class='content container'>");
        pw.print(ResponseUtil.escapeXml((String)title));
        pw.println("</th></tr>");
        if (description != null) {
            pw.print("<tr class='content'>");
            pw.print("<td colspan='3'class='content'>");
            pw.print(ResponseUtil.escapeXml((String)description));
            pw.println("</th></tr>");
        }
    }

    private void separatorHtml(PrintWriter pw) {
        pw.print("<tr class='content'>");
        pw.println("<td class='content' colspan='3'>&nbsp;</td>");
        pw.println("</tr>");
    }

    private void dumpMapText(PrintWriter pw, String title, Collection<MapEntry> list) {
        pw.println(title);
        String format = "%25s%25s%15s\r\n";
        pw.printf("%25s%25s%15s\r\n", "Pattern", "Replacement", "Redirect");
        for (MapEntry entry : list) {
            List<String> redir = Arrays.asList(entry.getRedirect());
            String status = entry.isInternal() ? "internal" : "external: " + entry.getStatus();
            pw.printf("%25s%25s%15s\r\n", entry.getPattern(), redir, status);
        }
    }

    private ServiceReference<ResourceProvider<?>> getServiceReference(long id) {
        try {
            Collection refs = this.bundleContext.getServiceReferences(ResourceProvider.class, "(service.id=" + String.valueOf(id) + ")");
            if (refs != null && !refs.isEmpty()) {
                ServiceReference rp = (ServiceReference)refs.iterator().next();
                return rp;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return null;
    }

    private void dumpDTOsHtml(PrintWriter pw) {
        StringBuilder sb;
        ServiceReference<ResourceProvider<?>> ref;
        this.titleHtml(pw, "Resource Providers", "Lists all available and activate resource prodivers.");
        pw.println("<tr class='content'>");
        pw.println("<th class='content'>Provider</th>");
        pw.println("<th class='content'>Path</th>");
        pw.println("<th class='content'>Configuration</th>");
        pw.println("</tr>");
        RuntimeDTO runtimeDTO = this.runtimeService.getRuntimeDTO();
        for (ResourceProviderDTO resourceProviderDTO : runtimeDTO.providers) {
            ref = this.getServiceReference(resourceProviderDTO.serviceId);
            sb = new StringBuilder();
            if (resourceProviderDTO.name != null) {
                sb.append(resourceProviderDTO.name);
                sb.append(' ');
            } else {
                sb.append("<unnamed> ");
            }
            if (ref != null) {
                sb.append("(serviceId = ");
                sb.append(resourceProviderDTO.serviceId);
                sb.append(", bundleId = ");
                sb.append(ref.getBundle().getBundleId());
                sb.append(")");
            }
            pw.print("<tr class='content'>");
            pw.print("<td class='content' style='vertical-align: top'>");
            pw.print(ResponseUtil.escapeXml((String)sb.toString()));
            pw.print("</td>");
            pw.print("<td class='content' style='vertical-align: top'>");
            pw.print(ResponseUtil.escapeXml((String)resourceProviderDTO.path));
            pw.print("</td>");
            pw.print("<td class='content' style='vertical-align: top'>");
            pw.print("auth=");
            pw.print(resourceProviderDTO.authType.name());
            pw.print("<br/>");
            pw.print("adaptable=");
            pw.print(resourceProviderDTO.adaptable);
            pw.print("<br/>");
            pw.print("attributable=");
            pw.print(resourceProviderDTO.attributable);
            pw.print("<br/>");
            pw.print("modifiable=");
            pw.print(resourceProviderDTO.modifiable);
            pw.print("<br/>");
            pw.print("refreshable=");
            pw.print(resourceProviderDTO.refreshable);
            pw.print("<br/>");
            pw.print("supportsQueryLanguage=");
            pw.print(resourceProviderDTO.supportsQueryLanguage);
            pw.print("<br/>");
            pw.print("useResourceAccessSecurity=");
            pw.print(resourceProviderDTO.useResourceAccessSecurity);
            pw.println("</td></tr>");
        }
        if (runtimeDTO.failedProviders.length > 0) {
            this.titleHtml(pw, "Failed Resource Providers", "Lists all failed providers.");
            pw.println("<tr class='content'>");
            pw.println("<th class='content'>Provider</th>");
            pw.println("<th class='content'>Path</th>");
            pw.println("<th class='content'>Reason</th>");
            pw.println("</tr>");
            for (ResourceProviderDTO resourceProviderDTO : runtimeDTO.failedProviders) {
                ref = this.getServiceReference(resourceProviderDTO.serviceId);
                sb = new StringBuilder();
                if (resourceProviderDTO.name != null) {
                    sb.append(resourceProviderDTO.name);
                    sb.append(' ');
                } else {
                    sb.append("<unnamed> ");
                }
                if (ref != null) {
                    sb.append("(serviceId = ");
                    sb.append(resourceProviderDTO.serviceId);
                    sb.append(", bundleId = ");
                    sb.append(ref.getBundle().getBundleId());
                    sb.append(")");
                }
                pw.print("<tr class='content'>");
                pw.print("<td class='content' style='vertical-align: top'>");
                pw.print(ResponseUtil.escapeXml((String)sb.toString()));
                pw.print("</td>");
                pw.print("<td class='content' style='vertical-align: top'>");
                pw.print(ResponseUtil.escapeXml((String)resourceProviderDTO.path));
                pw.print("</td>");
                pw.print("<td class='content' style='vertical-align: top'>");
                pw.print(resourceProviderDTO.reason.name());
                pw.println("</td></tr>");
            }
        }
    }

    private void dumpDTOsText(PrintWriter pw) {
        StringBuilder sb;
        ServiceReference<ResourceProvider<?>> ref;
        pw.println("Resource Providers");
        String format = "%35s %25s %15s\r\n";
        pw.printf("%35s %25s %15s\r\n", "Provider", "Path", "Configuration");
        RuntimeDTO runtimeDTO = this.runtimeService.getRuntimeDTO();
        for (ResourceProviderDTO resourceProviderDTO : runtimeDTO.providers) {
            ref = this.getServiceReference(resourceProviderDTO.serviceId);
            sb = new StringBuilder();
            if (resourceProviderDTO.name != null) {
                sb.append(resourceProviderDTO.name);
                sb.append(' ');
            } else {
                sb.append("<unnamed> ");
            }
            if (ref != null) {
                sb.append("(serviceId = ");
                sb.append(resourceProviderDTO.serviceId);
                sb.append(", bundleId = ");
                sb.append(ref.getBundle().getBundleId());
                sb.append(")");
            }
            StringBuilder config = new StringBuilder();
            config.append("auth=");
            config.append(resourceProviderDTO.authType.name());
            config.append(", adaptable=");
            config.append(resourceProviderDTO.adaptable);
            config.append(", attributable=");
            config.append(resourceProviderDTO.attributable);
            config.append(", modifiable=");
            config.append(resourceProviderDTO.modifiable);
            config.append(", refreshable=");
            config.append(resourceProviderDTO.refreshable);
            config.append(", supportsQueryLanguage=");
            config.append(resourceProviderDTO.supportsQueryLanguage);
            config.append(", useResourceAccessSecurity=");
            config.append(resourceProviderDTO.useResourceAccessSecurity);
            pw.printf("%35s %25s %15s\r\n", sb.toString(), resourceProviderDTO.path, config.toString());
        }
        pw.println();
        if (runtimeDTO.failedProviders.length > 0) {
            pw.println("Failed Resource Providers");
            pw.printf("%35s %25s %15s\r\n", "Provider", "Path", "Reason");
            for (ResourceProviderDTO resourceProviderDTO : runtimeDTO.failedProviders) {
                ref = this.getServiceReference(resourceProviderDTO.serviceId);
                sb = new StringBuilder();
                if (resourceProviderDTO.name != null) {
                    sb.append(resourceProviderDTO.name);
                    sb.append(' ');
                } else {
                    sb.append("<unnamed> ");
                }
                if (ref != null) {
                    sb.append("(serviceId = ");
                    sb.append(resourceProviderDTO.serviceId);
                    sb.append(", bundleId = ");
                    sb.append(ref.getBundle().getBundleId());
                    sb.append(")");
                }
                pw.printf("%35s %25s %15s\r\n", sb.toString(), resourceProviderDTO.path, resourceProviderDTO.reason.name());
            }
            pw.println();
        }
    }

    private void separatorText(PrintWriter pw) {
        pw.println();
    }

    private URL getResource(String path) {
        if (path.startsWith("/jcrresolver/res/ui/")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(12));
        }
        return null;
    }

    private static class ResolverRequest
    extends HttpServletRequestWrapper {
        private final URI uri;

        public ResolverRequest(HttpServletRequest request, String uriString) throws URIException {
            super(request);
            this.uri = new URI(uriString, false);
        }

        public String getScheme() {
            return this.uri.getScheme();
        }

        public String getServerName() {
            try {
                return this.uri.getHost();
            }
            catch (URIException ue) {
                return null;
            }
        }

        public int getServerPort() {
            return this.uri.getPort();
        }

        public String getPathInfo() {
            try {
                return this.uri.getPath();
            }
            catch (URIException ue) {
                return "";
            }
        }
    }
}

