/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sample.slingshot.model;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.sample.slingshot.model.PropertiesSupport;
import org.apache.sling.sample.slingshot.model.Stream;

public class StreamEntry
extends PropertiesSupport {
    public static final String RESOURCETYPE = "slingshot/Streamentry";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_LOCATION = "location";
    public static final String PROPERTY_TAGS = "tags";
    private volatile Stream stream;

    public StreamEntry(Resource resource) {
        super(resource);
    }

    public String getTitle() {
        String value = (String)this.getProperties().get(PROPERTY_TITLE, String.class);
        if (value == null) {
            value = this.resource != null ? this.resource.getName() : "No Title";
        }
        return value;
    }

    public String getDescription() {
        String value = (String)this.getProperties().get(PROPERTY_DESCRIPTION, (Object)"");
        return value;
    }

    public Stream getStream() {
        if (this.stream == null) {
            if (this.resource == null) {
                this.stream = new Stream(null);
            } else {
                Resource rsrc;
                for (rsrc = this.resource.getParent(); rsrc != null && !rsrc.isResourceType("slingshot/Stream"); rsrc = rsrc.getParent()) {
                }
                this.stream = new Stream(rsrc);
            }
        }
        return this.stream;
    }

    public String getLocation() {
        return (String)this.getProperties().get(PROPERTY_LOCATION, (Object)"");
    }
}

