/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.use;

public final class ProviderOutcome {
    private static final ProviderOutcome GENERIC_FAILURE = new ProviderOutcome(false, null, null);
    private final boolean success;
    private final Object result;
    private final Throwable cause;

    private ProviderOutcome(boolean success, Object result, Throwable cause) {
        this.success = success;
        this.result = result;
        this.cause = cause;
    }

    public static ProviderOutcome success(Object result) {
        return new ProviderOutcome(true, result, null);
    }

    public static ProviderOutcome failure() {
        return GENERIC_FAILURE;
    }

    public static ProviderOutcome failure(Throwable cause) {
        return new ProviderOutcome(false, null, cause);
    }

    public static ProviderOutcome notNullOrFailure(Object obj) {
        return obj == null ? ProviderOutcome.failure() : ProviderOutcome.success(obj);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public Object getResult() {
        if (!this.success) {
            throw new IllegalStateException("Outcome has not been successful");
        }
        return this.result;
    }

    public Throwable getCause() {
        return this.cause;
    }
}

