/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.util.Calendar;
import java.util.Iterator;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.servlets.post.impl.helper.SlingFileUploadHandler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Runnable.class}, property={"service.description=Periodic Chunk Cleanup Job", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class)
public class ChunkCleanUpTask
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory rrFactory;
    private SlingFileUploadHandler uploadhandler = new SlingFileUploadHandler();
    private long chunkCleanUpAge;

    @Override
    public void run() {
        this.log.debug("ChunkCleanUpTask: Starting cleanup");
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long start = System.currentTimeMillis();
        int numCleaned = 0;
        int numLive = 0;
        try (ResourceResolver admin = null;){
            admin = this.rrFactory.getAdministrativeResourceResolver(null);
            Iterator rsrcIter = admin.findResources("SELECT * FROM [sling:chunks] ", "sql");
            while (rsrcIter.hasNext()) {
                Resource rsrc = (Resource)rsrcIter.next();
                if (this.isEligibleForCleanUp(rsrc)) {
                    ++numCleaned;
                    this.uploadhandler.deleteChunks(rsrc);
                    continue;
                }
                ++numLive;
            }
            if (admin.hasChanges()) {
                try {
                    admin.refresh();
                    admin.commit();
                }
                catch (PersistenceException re) {
                    this.log.info("ChunkCleanUpTask: Failed persisting chunk removal. Retrying later");
                }
            }
        }
        long end = System.currentTimeMillis();
        this.log.info("ChunkCleanUpTask finished: Removed {} chunk upload(s) in {}ms ({} chunk upload(s) still active)", new Object[]{numCleaned, end - start, numLive});
    }

    private boolean isEligibleForCleanUp(Resource rsrc) {
        Calendar created;
        boolean result = false;
        Resource lastChunkNode = this.uploadhandler.getLastChunk(rsrc);
        if (lastChunkNode != null && (created = (Calendar)lastChunkNode.getValueMap().get("jcr:created", Calendar.class)) != null && System.currentTimeMillis() - created.getTimeInMillis() > this.chunkCleanUpAge) {
            result = true;
        }
        return result;
    }

    @Activate
    protected void activate(Config configuration) {
        this.chunkCleanUpAge = configuration.chunk_cleanup_age();
        this.log.info("scheduler config [{}], chunkGarbageTime  [{}] ms", (Object)configuration.scheduler_expression(), (Object)this.chunkCleanUpAge);
    }

    @ObjectClassDefinition(name="Apache Sling Post Chunk Upload : Cleanup Task", description="Task to regularly purge incomplete chunks from the repository")
    public static @interface Config {
        @AttributeDefinition(name="Schedule", description="Cron expression scheudling this job. Default is hourly 17m23s after the hour. See http://www.docjar.com/docs/api/org/quartz/CronTrigger.html for a description of the format for this value.")
        public String scheduler_expression() default "31 41 0/12 * * ?";

        @AttributeDefinition(name="scheduler.concurrent", description="Allow Chunk Cleanup Task to run concurrently (default: false).")
        public boolean scheduler_concurrent() default false;

        @AttributeDefinition(name="Cleanup Age", description="The chunk's age in minutes before it is considered for clean up.")
        public int chunk_cleanup_age() default 360;
    }
}

