/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.sitemap.impl.SitemapStorageInfo;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventProperties;

final class SitemapEventUtil {
    private SitemapEventUtil() {
    }

    static Event newUpdateEvent(SitemapStorageInfo storageInfo, Resource sitemapRoot) {
        HashMap<String, Object> props = new HashMap<String, Object>(5);
        props.put("sitemap.name", storageInfo.getName());
        props.put("sitemap.root", sitemapRoot.getPath());
        props.put("sitemap.urls", storageInfo.getEntries());
        props.put("sitemap.storagePath", storageInfo.getPath());
        props.put("sitemap.storageSize", storageInfo.getSize());
        return new Event("org/apache/sling/sitemap/UPDATED", (Map)new EventProperties(props));
    }

    static Event newPurgeEvent(String path) {
        Map<String, String> properties = Collections.singletonMap("sitemap.storagePath", path);
        return new Event("org/apache/sling/sitemap/PURGED", (Map)new EventProperties(properties));
    }
}

