/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.builder;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sling.sitemap.SitemapException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SitemapIndexImpl
implements Closeable {
    private final XMLStreamWriter out;
    private boolean closed;

    public SitemapIndexImpl(Writer writer) throws IOException {
        try {
            this.out = XMLOutputFactory.newFactory().createXMLStreamWriter(writer);
            this.out.writeStartDocument("UTF-8", "1.0");
            this.out.writeStartElement("sitemapindex");
            this.out.writeDefaultNamespace("http://www.sitemaps.org/schemas/sitemap/0.9");
        }
        catch (XMLStreamException ex) {
            throw new IOException("Failed to open sitemap index", ex);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.ensureNotClosed();
            this.closed = true;
            this.out.writeEndElement();
            this.out.flush();
            this.out.close();
        }
        catch (XMLStreamException ex) {
            throw new IOException("Failed to close sitemap index", ex);
        }
    }

    public void addSitemap(@NotNull String location) throws SitemapException {
        this.addSitemap(location, null);
    }

    public void addSitemap(@NotNull String location, @Nullable Instant lastModified) throws SitemapException {
        try {
            this.ensureNotClosed();
            this.out.writeStartElement("sitemap");
            this.out.writeStartElement("loc");
            this.out.writeCharacters(location);
            this.out.writeEndElement();
            if (lastModified != null) {
                this.out.writeStartElement("lastmod");
                this.out.writeCharacters(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastModified.atOffset(ZoneOffset.UTC)));
                this.out.writeEndElement();
            }
            this.out.writeEndElement();
            this.out.flush();
        }
        catch (XMLStreamException ex) {
            throw new SitemapException("Failed to add sitemap to index", ex);
        }
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Sitemap already closed");
        }
    }
}

