/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.CaseTermQuery;
import org.apache.jackrabbit.core.query.lucene.ChildAxisQuery;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DecimalField;
import org.apache.jackrabbit.core.query.lucene.DerefQuery;
import org.apache.jackrabbit.core.query.lucene.DescendantSelfAxisQuery;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.JackrabbitQueryParser;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.MatchAllDocsQuery;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NameQuery;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NotQuery;
import org.apache.jackrabbit.core.query.lucene.ParentAxisQuery;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.PredicateDerefQuery;
import org.apache.jackrabbit.core.query.lucene.RangeQuery;
import org.apache.jackrabbit.core.query.lucene.SimilarityQuery;
import org.apache.jackrabbit.core.query.lucene.SynonymProvider;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.WildcardNameQuery;
import org.apache.jackrabbit.core.query.lucene.WildcardQuery;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.AndQueryNode;
import org.apache.jackrabbit.spi.commons.query.DefaultQueryNodeVisitor;
import org.apache.jackrabbit.spi.commons.query.DerefQueryNode;
import org.apache.jackrabbit.spi.commons.query.ExactQueryNode;
import org.apache.jackrabbit.spi.commons.query.LocationStepQueryNode;
import org.apache.jackrabbit.spi.commons.query.NodeTypeQueryNode;
import org.apache.jackrabbit.spi.commons.query.NotQueryNode;
import org.apache.jackrabbit.spi.commons.query.OrQueryNode;
import org.apache.jackrabbit.spi.commons.query.OrderQueryNode;
import org.apache.jackrabbit.spi.commons.query.PathQueryNode;
import org.apache.jackrabbit.spi.commons.query.PropertyFunctionQueryNode;
import org.apache.jackrabbit.spi.commons.query.QueryNode;
import org.apache.jackrabbit.spi.commons.query.QueryNodeVisitor;
import org.apache.jackrabbit.spi.commons.query.QueryRootNode;
import org.apache.jackrabbit.spi.commons.query.RelationQueryNode;
import org.apache.jackrabbit.spi.commons.query.TextsearchQueryNode;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.XMLChar;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneQueryBuilder
implements QueryNodeVisitor {
    private static final Logger log = LoggerFactory.getLogger(LuceneQueryBuilder.class);
    private static final PathFactory PATH_FACTORY = PathFactoryImpl.getInstance();
    private static final Name PARENT_ELEMENT_NAME = PATH_FACTORY.getParentElement().getName();
    private static final Name FN_NAME = NameFactoryImpl.getInstance().create("http://www.w3.org/2005/xpath-functions", "name()");
    private final QueryRootNode root;
    private final SessionImpl session;
    private final ItemStateManager sharedItemMgr;
    private final HierarchyManager hmgr;
    private final NamespaceMappings nsMappings;
    private final NamePathResolver resolver;
    private final Analyzer analyzer;
    private final PropertyTypeRegistry propRegistry;
    private final SynonymProvider synonymProvider;
    private final IndexFormatVersion indexFormatVersion;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private final PerQueryCache cache;

    private LuceneQueryBuilder(QueryRootNode root, SessionImpl session, ItemStateManager sharedItemMgr, HierarchyManager hmgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion, PerQueryCache cache) {
        this.root = root;
        this.session = session;
        this.sharedItemMgr = sharedItemMgr;
        this.hmgr = hmgr;
        this.nsMappings = nsMappings;
        this.analyzer = analyzer;
        this.propRegistry = propReg;
        this.synonymProvider = synonymProvider;
        this.indexFormatVersion = indexFormatVersion;
        this.cache = cache;
        this.resolver = NamePathResolverImpl.create(nsMappings);
    }

    public static Query createQuery(QueryRootNode root, SessionImpl session, ItemStateManager sharedItemMgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion, PerQueryCache cache) throws RepositoryException {
        HierarchyManagerImpl hmgr = new HierarchyManagerImpl(RepositoryImpl.ROOT_NODE_ID, sharedItemMgr);
        LuceneQueryBuilder builder = new LuceneQueryBuilder(root, session, sharedItemMgr, hmgr, nsMappings, analyzer, propReg, synonymProvider, indexFormatVersion, cache);
        Query q = builder.createLuceneQuery();
        if (builder.exceptions.size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (Exception exception : builder.exceptions) {
                msg.append(exception.toString()).append('\n');
            }
            throw new RepositoryException("Exception building query: " + msg.toString());
        }
        return q;
    }

    private Query createLuceneQuery() throws RepositoryException {
        return (Query)this.root.accept(this, null);
    }

    public Object visit(QueryRootNode node, Object data) throws RepositoryException {
        BooleanQuery root;
        BooleanQuery wrapped = root = new BooleanQuery();
        if (node.getLocationNode() != null) {
            wrapped = (Query)node.getLocationNode().accept(this, root);
        }
        return wrapped;
    }

    public Object visit(OrQueryNode node, Object data) throws RepositoryException {
        Object[] result;
        BooleanQuery orQuery = new BooleanQuery();
        for (Object aResult : result = node.acceptOperands(this, null)) {
            Query operand = (Query)aResult;
            if (operand instanceof BooleanQuery) {
                boolean hasNonOptional = false;
                for (BooleanClause clause : ((BooleanQuery)operand).getClauses()) {
                    if (!clause.isProhibited() && !clause.isRequired()) continue;
                    hasNonOptional = true;
                    break;
                }
                if (hasNonOptional) {
                    orQuery.add(operand, BooleanClause.Occur.SHOULD);
                    continue;
                }
                for (BooleanClause clause : ((BooleanQuery)operand).getClauses()) {
                    orQuery.add(clause);
                }
                continue;
            }
            orQuery.add(operand, BooleanClause.Occur.SHOULD);
        }
        return orQuery;
    }

    public Object visit(AndQueryNode node, Object data) throws RepositoryException {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return null;
        }
        BooleanQuery andQuery = new BooleanQuery();
        for (Object aResult : result) {
            Query operand = (Query)aResult;
            andQuery.add(operand, BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    public Object visit(NotQueryNode node, Object data) throws RepositoryException {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return data;
        }
        BooleanQuery b = new BooleanQuery();
        for (Object aResult : result) {
            b.add((Query)aResult, BooleanClause.Occur.SHOULD);
        }
        return new NotQuery((Query)b);
    }

    public Object visit(ExactQueryNode node, Object data) {
        String field = "";
        String value = "";
        try {
            field = this.resolver.getJCRName(node.getPropertyName());
            value = this.resolver.getJCRName(node.getValue());
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        return new JackrabbitTermQuery(new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value)));
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        ArrayList<Term> terms = new ArrayList<Term>();
        try {
            Term t;
            String mixinTypesField = this.resolver.getJCRName(NameConstants.JCR_MIXINTYPES);
            String primaryTypeField = this.resolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
            NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
            NodeType base = ntMgr.getNodeType(this.session.getJCRName(node.getValue()));
            if (base.isMixin()) {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, this.resolver.getJCRName(node.getValue())));
                terms.add(t);
            } else {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, this.resolver.getJCRName(node.getValue())));
                terms.add(t);
            }
            NodeTypeIterator allTypes = ntMgr.getAllNodeTypes();
            while (allTypes.hasNext()) {
                NodeType nt = allTypes.nextNodeType();
                NodeType[] superTypes = nt.getSupertypes();
                if (!Arrays.asList(superTypes).contains(base)) continue;
                Name n = this.session.getQName(nt.getName());
                String ntName = this.nsMappings.translateName(n);
                Term t2 = nt.isMixin() ? new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, ntName)) : new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, ntName));
                terms.add(t2);
            }
        }
        catch (NameException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        catch (RepositoryException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        if (terms.size() == 0) {
            return new BooleanQuery();
        }
        if (terms.size() == 1) {
            return new JackrabbitTermQuery((Term)terms.get(0));
        }
        BooleanQuery b = new BooleanQuery();
        for (Term term : terms) {
            b.add((Query)new JackrabbitTermQuery(term), BooleanClause.Occur.SHOULD);
        }
        return b;
    }

    public Object visit(TextsearchQueryNode node, Object data) {
        try {
            String fieldname;
            Path relPath = node.getRelativePath();
            if (relPath == null || !node.getReferencesProperty()) {
                fieldname = FieldNames.FULLTEXT;
            } else {
                Name propName = relPath.getName();
                StringBuffer tmp = new StringBuffer();
                tmp.append(this.nsMappings.getPrefix(propName.getNamespaceURI()));
                tmp.append(":").append("FULL:");
                tmp.append(propName.getLocalName());
                fieldname = tmp.toString();
            }
            JackrabbitQueryParser parser = new JackrabbitQueryParser(fieldname, this.analyzer, this.synonymProvider, this.cache);
            Query context = parser.parse(node.getQuery());
            if (!(relPath == null || node.getReferencesProperty() && relPath.getLength() <= 1)) {
                Path.Element[] elements = relPath.getElements();
                for (int i = elements.length - 1; i >= 0; --i) {
                    Name name = null;
                    if (!elements[i].getName().equals(RelationQueryNode.STAR_NAME_TEST)) {
                        name = elements[i].getName();
                    }
                    if (name != null && (node.getReferencesProperty() && i == elements.length - 2 || !node.getReferencesProperty() && i == elements.length - 1)) {
                        NameQuery q = new NameQuery(name, this.indexFormatVersion, this.nsMappings);
                        BooleanQuery and = new BooleanQuery();
                        and.add((Query)q, BooleanClause.Occur.MUST);
                        and.add(context, BooleanClause.Occur.MUST);
                        context = and;
                        continue;
                    }
                    if ((!node.getReferencesProperty() || i >= elements.length - 2) && (node.getReferencesProperty() || i >= elements.length - 1)) continue;
                    context = new ParentAxisQuery(context, name, this.indexFormatVersion, this.nsMappings);
                }
                context = new ParentAxisQuery(context, null, this.indexFormatVersion, this.nsMappings);
            }
            return context;
        }
        catch (NamespaceException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        catch (ParseException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        return null;
    }

    public Object visit(PathQueryNode node, Object data) throws RepositoryException {
        BooleanQuery constraint;
        JackrabbitTermQuery context = null;
        LocationStepQueryNode[] steps = node.getPathSteps();
        if (steps.length > 0) {
            if (node.isAbsolute() && !steps[0].getIncludeDescendants()) {
                Name nameTest = steps[0].getNameTest();
                if (nameTest == null) {
                    context = new JackrabbitTermQuery(new Term(FieldNames.PARENT, ""));
                } else if (nameTest.getLocalName().length() == 0) {
                    context = new JackrabbitTermQuery(new Term(FieldNames.PARENT, ""));
                } else {
                    BooleanQuery and = new BooleanQuery();
                    and.add((Query)new JackrabbitTermQuery(new Term(FieldNames.PARENT, "")), BooleanClause.Occur.MUST);
                    and.add((Query)new NameQuery(nameTest, this.indexFormatVersion, this.nsMappings), BooleanClause.Occur.MUST);
                    context = and;
                }
                Object[] predicates = steps[0].acceptOperands(this, (Object)context);
                BooleanQuery andQuery = new BooleanQuery();
                for (Object predicate : predicates) {
                    andQuery.add((Query)predicate, BooleanClause.Occur.MUST);
                }
                if (andQuery.clauses().size() > 0) {
                    andQuery.add((Query)context, BooleanClause.Occur.MUST);
                    context = andQuery;
                }
                LocationStepQueryNode[] tmp = new LocationStepQueryNode[steps.length - 1];
                System.arraycopy(steps, 1, tmp, 0, steps.length - 1);
                steps = tmp;
            } else {
                context = new JackrabbitTermQuery(new Term(FieldNames.PARENT, ""));
            }
        } else {
            this.exceptions.add((Exception)new InvalidQueryException("Number of location steps must be > 0"));
        }
        for (LocationStepQueryNode step : steps) {
            context = (Query)step.accept(this, (Object)context);
        }
        if (data instanceof BooleanQuery && (constraint = (BooleanQuery)data).getClauses().length > 0) {
            constraint.add((Query)context, BooleanClause.Occur.MUST);
            context = constraint;
        }
        return context;
    }

    public Object visit(LocationStepQueryNode node, Object data) throws RepositoryException {
        QueryNode[] pred;
        Object[] predicates;
        Query context = (Query)data;
        BooleanQuery andQuery = new BooleanQuery();
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        for (Object predicate : predicates = node.acceptOperands(this, data)) {
            andQuery.add((Query)predicate, BooleanClause.Occur.MUST);
        }
        for (QueryNode aPred : pred = node.getPredicates()) {
            RelationQueryNode pos;
            if (aPred.getType() != 2 || (pos = (RelationQueryNode)aPred).getValueType() != 6) continue;
            node.setIndex(pos.getPositionValue());
        }
        NameQuery nameTest = null;
        if (node.getNameTest() != null) {
            if (node.getNameTest().equals(PARENT_ELEMENT_NAME)) {
                andQuery.add((Query)new ParentAxisQuery(context, null, this.indexFormatVersion, this.nsMappings), BooleanClause.Occur.MUST);
                return andQuery;
            }
            nameTest = new NameQuery(node.getNameTest(), this.indexFormatVersion, this.nsMappings);
        }
        if (node.getIncludeDescendants()) {
            if (nameTest != null) {
                andQuery.add((Query)new DescendantSelfAxisQuery(context, nameTest, false), BooleanClause.Occur.MUST);
            } else if (predicates.length > 0) {
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    DescendantSelfAxisQuery subQuery = new DescendantSelfAxisQuery(context, (Query)andQuery, false);
                    andQuery = new BooleanQuery();
                    andQuery.add((Query)subQuery, BooleanClause.Occur.MUST);
                }
            } else {
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    if (node.getIndex() == -2147483647) {
                        context = new DescendantSelfAxisQuery(context, false);
                        andQuery.add(context, BooleanClause.Occur.MUST);
                    } else {
                        context = new DescendantSelfAxisQuery(context, true);
                        andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex(), this.indexFormatVersion, this.nsMappings), BooleanClause.Occur.MUST);
                    }
                } else {
                    andQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                }
            }
        } else if (nameTest != null) {
            andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, nameTest.getName(), node.getIndex(), this.indexFormatVersion, this.nsMappings), BooleanClause.Occur.MUST);
        } else {
            andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex(), this.indexFormatVersion, this.nsMappings), BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    public Object visit(DerefQueryNode node, Object data) throws RepositoryException {
        Query context = (Query)data;
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        try {
            String refProperty = this.resolver.getJCRName(node.getRefProperty());
            if (node.getIncludeDescendants()) {
                Query refPropQuery = Util.createMatchAllQuery(refProperty, this.indexFormatVersion, this.cache);
                context = new DescendantSelfAxisQuery(context, refPropQuery, false);
            }
            context = new DerefQuery(context, refProperty, node.getNameTest(), this.indexFormatVersion, this.nsMappings);
            Object[] predicates = node.acceptOperands(this, data);
            if (predicates.length > 0) {
                BooleanQuery andQuery = new BooleanQuery();
                for (Object predicate : predicates) {
                    andQuery.add((Query)predicate, BooleanClause.Occur.MUST);
                }
                andQuery.add(context, BooleanClause.Occur.MUST);
                context = andQuery;
            }
        }
        catch (NamespaceException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        return context;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object visit(RelationQueryNode node, Object data) throws RepositoryException {
        void var6_49;
        LocationStepQueryNode[] steps;
        block69: {
            String field;
            int[] transform;
            String[] stringValues;
            block70: {
                PathQueryNode relPath = node.getRelativePath();
                if (relPath == null && node.getOperation() != 28 && node.getOperation() != 29) {
                    this.exceptions.add((Exception)new InvalidQueryException("@* not supported in predicate"));
                    return data;
                }
                steps = relPath.getPathSteps();
                Name propertyName = node.getOperation() == 28 ? NameConstants.JCR_PRIMARYTYPE : steps[steps.length - 1].getNameTest();
                stringValues = new String[1];
                switch (node.getValueType()) {
                    case 0: {
                        break;
                    }
                    case 4: {
                        stringValues[0] = DateField.dateToString(node.getDateValue());
                        break;
                    }
                    case 2: {
                        stringValues[0] = DoubleField.doubleToString(node.getDoubleValue());
                        break;
                    }
                    case 1: {
                        stringValues[0] = LongField.longToString(node.getLongValue());
                        break;
                    }
                    case 3: {
                        if (node.getOperation() == 12 || node.getOperation() == 11 || node.getOperation() == 14 || node.getOperation() == 13) {
                            stringValues = this.getStringValues(propertyName, node.getStringValue());
                            break;
                        }
                        stringValues[0] = node.getStringValue();
                        break;
                    }
                    case 6: {
                        return null;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown relation type: " + node.getValueType());
                    }
                }
                transform = new int[]{0};
                node.acceptOperands(new DefaultQueryNodeVisitor(){

                    public Object visit(PropertyFunctionQueryNode node, Object data) {
                        if (node.getFunctionName().equals("lower-case")) {
                            transform[0] = 1;
                        } else if (node.getFunctionName().equals("upper-case")) {
                            transform[0] = 2;
                        }
                        return data;
                    }
                }, null);
                field = "";
                try {
                    field = this.resolver.getJCRName(propertyName);
                }
                catch (NamespaceException e) {
                    this.exceptions.add((Exception)((Object)e));
                }
                if (!propertyName.equals(FN_NAME)) break block70;
                if (node.getValueType() != 3) {
                    this.exceptions.add((Exception)new InvalidQueryException("Name function can only be used in conjunction with a string literal"));
                    return data;
                }
                if (node.getOperation() == 11 || node.getOperation() == 12) {
                    if (XMLChar.isValidName(node.getStringValue())) {
                        try {
                            Name n = this.session.getQName(ISO9075.decode(node.getStringValue()));
                            NameQuery nameQuery = new NameQuery(n, this.indexFormatVersion, this.nsMappings);
                        }
                        catch (NameException e) {
                            this.exceptions.add((Exception)((Object)e));
                            return data;
                        }
                        catch (NamespaceException e) {
                            this.exceptions.add((Exception)((Object)e));
                            return data;
                        }
                    } else {
                        BooleanQuery booleanQuery = new BooleanQuery();
                    }
                    break block69;
                } else {
                    if (node.getOperation() != 23) {
                        this.exceptions.add((Exception)new InvalidQueryException("Name function can only be used in conjunction with the following operators: equals, like"));
                        return data;
                    }
                    if (stringValues[0].equals("%")) {
                        org.apache.lucene.search.MatchAllDocsQuery matchAllDocsQuery = new org.apache.lucene.search.MatchAllDocsQuery();
                        break block69;
                    } else {
                        WildcardNameQuery wildcardNameQuery = new WildcardNameQuery(stringValues[0], transform[0], this.session, this.nsMappings, this.cache);
                    }
                }
                break block69;
            }
            switch (node.getOperation()) {
                case 11: 
                case 12: {
                    BooleanQuery or = new BooleanQuery();
                    for (String value : stringValues) {
                        void var16_73;
                        Term t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value));
                        if (transform[0] == 2) {
                            CaseTermQuery.Upper upper = new CaseTermQuery.Upper(t);
                        } else if (transform[0] == 1) {
                            CaseTermQuery.Lower lower = new CaseTermQuery.Lower(t);
                        } else {
                            JackrabbitTermQuery jackrabbitTermQuery = new JackrabbitTermQuery(t);
                        }
                        or.add((Query)var16_73, BooleanClause.Occur.SHOULD);
                    }
                    BooleanQuery booleanQuery = or;
                    if (node.getOperation() != 11) break;
                    Query query = this.createSingleValueConstraint((Query)or, field);
                    break;
                }
                case 19: 
                case 20: {
                    Term lower;
                    BooleanQuery or = new BooleanQuery();
                    for (String value : stringValues) {
                        lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value));
                        Term term = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                        or.add((Query)new RangeQuery(lower, term, true, transform[0], this.cache), BooleanClause.Occur.SHOULD);
                    }
                    BooleanQuery booleanQuery = or;
                    if (node.getOperation() != 19) break;
                    Query query = this.createSingleValueConstraint((Query)or, field);
                    break;
                }
                case 17: 
                case 18: {
                    Term lower;
                    BooleanQuery or = new BooleanQuery();
                    for (String value : stringValues) {
                        lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value));
                        Term term = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                        or.add((Query)new RangeQuery(lower, term, false, transform[0], this.cache), BooleanClause.Occur.SHOULD);
                    }
                    BooleanQuery booleanQuery = or;
                    if (node.getOperation() != 17) break;
                    Query query = this.createSingleValueConstraint((Query)or, field);
                    break;
                }
                case 21: 
                case 22: {
                    Term lower;
                    BooleanQuery or = new BooleanQuery();
                    for (String value : stringValues) {
                        lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                        Term term = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value));
                        or.add((Query)new RangeQuery(lower, term, true, transform[0], this.cache), BooleanClause.Occur.SHOULD);
                    }
                    BooleanQuery booleanQuery = or;
                    if (node.getOperation() != 21) break;
                    Query query = this.createSingleValueConstraint((Query)booleanQuery, field);
                    break;
                }
                case 23: {
                    if (stringValues[0].equals("%")) {
                        Query query = Util.createMatchAllQuery(field, this.indexFormatVersion, this.cache);
                        break;
                    }
                    WildcardQuery wildcardQuery = new WildcardQuery(FieldNames.PROPERTIES, field, stringValues[0], transform[0], this.cache);
                    break;
                }
                case 15: 
                case 16: {
                    Term lower;
                    BooleanQuery or = new BooleanQuery();
                    for (String value : stringValues) {
                        lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                        Term term = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value));
                        or.add((Query)new RangeQuery(lower, term, false, transform[0], this.cache), BooleanClause.Occur.SHOULD);
                    }
                    BooleanQuery booleanQuery = or;
                    if (node.getOperation() != 15) break;
                    Query query = this.createSingleValueConstraint((Query)or, field);
                    break;
                }
                case 13: {
                    BooleanQuery notQuery = new BooleanQuery();
                    notQuery.add(Util.createMatchAllQuery(field, this.indexFormatVersion, this.cache), BooleanClause.Occur.SHOULD);
                    for (String value : stringValues) {
                        void var17_84;
                        Term term = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value));
                        if (transform[0] == 2) {
                            CaseTermQuery.Upper upper = new CaseTermQuery.Upper(term);
                        } else if (transform[0] == 1) {
                            CaseTermQuery.Lower lower = new CaseTermQuery.Lower(term);
                        } else {
                            JackrabbitTermQuery jackrabbitTermQuery = new JackrabbitTermQuery(term);
                        }
                        notQuery.add((Query)var17_84, BooleanClause.Occur.MUST_NOT);
                    }
                    notQuery.add((Query)new JackrabbitTermQuery(new Term(FieldNames.MVP, field)), BooleanClause.Occur.MUST_NOT);
                    BooleanQuery booleanQuery = notQuery;
                    break;
                }
                case 14: {
                    BooleanQuery notQuery = new BooleanQuery();
                    notQuery.add(Util.createMatchAllQuery(field, this.indexFormatVersion, this.cache), BooleanClause.Occur.SHOULD);
                    for (String value : stringValues) {
                        void var19_91;
                        Term term = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value));
                        NotQuery notQuery2 = new NotQuery((Query)new JackrabbitTermQuery(new Term(FieldNames.MVP, field)));
                        BooleanQuery and = new BooleanQuery();
                        if (transform[0] == 2) {
                            CaseTermQuery.Upper upper = new CaseTermQuery.Upper(term);
                        } else if (transform[0] == 1) {
                            CaseTermQuery.Lower lower = new CaseTermQuery.Lower(term);
                        } else {
                            JackrabbitTermQuery jackrabbitTermQuery = new JackrabbitTermQuery(term);
                        }
                        and.add((Query)var19_91, BooleanClause.Occur.MUST);
                        and.add((Query)notQuery2, BooleanClause.Occur.MUST);
                        notQuery.add((Query)and, BooleanClause.Occur.MUST_NOT);
                    }
                    BooleanQuery booleanQuery = notQuery;
                    break;
                }
                case 26: {
                    NotQuery notQuery = new NotQuery(Util.createMatchAllQuery(field, this.indexFormatVersion, this.cache));
                    break;
                }
                case 28: {
                    try {
                        NodeId id = this.hmgr.resolveNodePath(this.session.getQPath(node.getStringValue()));
                        if (id != null) {
                            SimilarityQuery similarityQuery = new SimilarityQuery(id.toString(), this.analyzer);
                            break;
                        }
                        BooleanQuery booleanQuery = new BooleanQuery();
                    }
                    catch (Exception e) {
                        this.exceptions.add(e);
                        BooleanQuery booleanQuery = new BooleanQuery();
                    }
                    break;
                }
                case 27: {
                    Query query = Util.createMatchAllQuery(field, this.indexFormatVersion, this.cache);
                    break;
                }
                case 29: {
                    Query query = Util.createMatchAllQuery(field, this.indexFormatVersion, this.cache);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown relation operation: " + node.getOperation());
                }
            }
        }
        if (steps.length > 1) {
            void var6_40;
            boolean selectParent = true;
            for (int i = steps.length - 2; i >= 0; --i) {
                LocationStepQueryNode step = steps[i];
                Name name = steps[i].getNameTest();
                if (i == steps.length - 2) {
                    if (step instanceof DerefQueryNode) {
                        Query query = this.createPredicateDeref((Query)var6_40, (DerefQueryNode)step, data);
                        if (steps.length != 2) continue;
                        selectParent = false;
                        continue;
                    }
                    if (!(step instanceof LocationStepQueryNode) || name == null) continue;
                    if (!name.equals(PARENT_ELEMENT_NAME)) {
                        NameQuery nameTest = new NameQuery(name, this.indexFormatVersion, this.nsMappings);
                        BooleanQuery and = new BooleanQuery();
                        and.add((Query)var6_40, BooleanClause.Occur.MUST);
                        and.add((Query)nameTest, BooleanClause.Occur.MUST);
                        BooleanQuery booleanQuery = and;
                        continue;
                    }
                    ChildAxisQuery childAxisQuery = new ChildAxisQuery(this.sharedItemMgr, (Query)var6_40, null, this.indexFormatVersion, this.nsMappings);
                    selectParent = false;
                    continue;
                }
                if (name != null && name.equals(PARENT_ELEMENT_NAME)) {
                    void var6_45;
                    if (selectParent) {
                        ParentAxisQuery parentAxisQuery = new ParentAxisQuery((Query)var6_40, null, this.indexFormatVersion, this.nsMappings);
                        selectParent = false;
                    }
                    ChildAxisQuery childAxisQuery = new ChildAxisQuery(this.sharedItemMgr, (Query)var6_45, null, this.indexFormatVersion, this.nsMappings);
                    continue;
                }
                if (!(step instanceof LocationStepQueryNode)) {
                    throw new UnsupportedOperationException();
                }
                ParentAxisQuery parentAxisQuery = new ParentAxisQuery((Query)var6_40, name, this.indexFormatVersion, this.nsMappings);
            }
            if (selectParent) {
                ParentAxisQuery parentAxisQuery = new ParentAxisQuery((Query)var6_40, null, this.indexFormatVersion, this.nsMappings);
            }
        }
        return var6_49;
    }

    public Query createPredicateDeref(Query subQuery, DerefQueryNode node, Object data) throws RepositoryException {
        Query context = (Query)data;
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        try {
            String refProperty = this.resolver.getJCRName(node.getRefProperty());
            context = new PredicateDerefQuery(subQuery, refProperty, node.getNameTest(), this.indexFormatVersion, this.nsMappings);
            Object[] predicates = node.acceptOperands(this, data);
            if (predicates.length > 0) {
                BooleanQuery andQuery = new BooleanQuery();
                for (Object predicate : predicates) {
                    andQuery.add((Query)predicate, BooleanClause.Occur.MUST);
                }
                andQuery.add(context, BooleanClause.Occur.MUST);
                context = andQuery;
            }
        }
        catch (NamespaceException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        return context;
    }

    public Object visit(OrderQueryNode node, Object data) {
        return data;
    }

    public Object visit(PropertyFunctionQueryNode node, Object data) {
        return data;
    }

    private Query createSingleValueConstraint(Query q, String propName) {
        JackrabbitTermQuery mvp = new JackrabbitTermQuery(new Term(FieldNames.MVP, propName));
        NotQuery svp = new NotQuery((Query)mvp);
        BooleanQuery and = new BooleanQuery();
        and.add(q, BooleanClause.Occur.MUST);
        and.add((Query)svp, BooleanClause.Occur.MUST);
        return and;
    }

    private String[] getStringValues(Name propertyName, String literal) {
        PropertyTypeRegistry.TypeMapping[] types = this.propRegistry.getPropertyTypes(propertyName);
        ArrayList<String> values = new ArrayList<String>();
        block29: for (PropertyTypeRegistry.TypeMapping type : types) {
            switch (type.type) {
                case 7: {
                    try {
                        Name n = this.session.getQName(literal);
                        values.add(this.nsMappings.translateName(n));
                        log.debug("Coerced " + literal + " into NAME.");
                    }
                    catch (NameException e) {
                        log.debug("Unable to coerce '" + literal + "' into a NAME: " + e.toString());
                    }
                    catch (NamespaceException e) {
                        log.debug("Unable to coerce '" + literal + "' into a NAME: " + e.toString());
                    }
                    continue block29;
                }
                case 8: {
                    try {
                        Path p = this.session.getQPath(literal);
                        values.add(this.resolver.getJCRPath(p));
                        log.debug("Coerced " + literal + " into PATH.");
                    }
                    catch (NameException e) {
                        log.debug("Unable to coerce '" + literal + "' into a PATH: " + e.toString());
                    }
                    catch (NamespaceException e) {
                        log.debug("Unable to coerce '" + literal + "' into a PATH: " + e.toString());
                    }
                    continue block29;
                }
                case 5: {
                    Calendar c = ISO8601.parse(literal);
                    if (c != null) {
                        values.add(DateField.timeToString(c.getTimeInMillis()));
                        log.debug("Coerced " + literal + " into DATE.");
                        continue block29;
                    }
                    log.debug("Unable to coerce '" + literal + "' into a DATE.");
                    continue block29;
                }
                case 4: {
                    try {
                        double d = Double.parseDouble(literal);
                        values.add(DoubleField.doubleToString(d));
                        log.debug("Coerced " + literal + " into DOUBLE.");
                    }
                    catch (NumberFormatException e) {
                        log.debug("Unable to coerce '" + literal + "' into a DOUBLE: " + e.toString());
                    }
                    continue block29;
                }
                case 3: {
                    try {
                        long l = Long.parseLong(literal);
                        values.add(LongField.longToString(l));
                        log.debug("Coerced " + literal + " into LONG.");
                    }
                    catch (NumberFormatException e) {
                        log.debug("Unable to coerce '" + literal + "' into a LONG: " + e.toString());
                    }
                    continue block29;
                }
                case 12: {
                    try {
                        BigDecimal d = new BigDecimal(literal);
                        values.add(DecimalField.decimalToString(d));
                        log.debug("Coerced " + literal + " into DECIMAL.");
                    }
                    catch (NumberFormatException e) {
                        log.debug("Unable to coerce '" + literal + "' into a DECIMAL: " + e.toString());
                    }
                    continue block29;
                }
                case 1: 
                case 11: {
                    values.add(literal);
                    log.debug("Using literal " + literal + " as is.");
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            if (literal.indexOf(47) > -1) {
                try {
                    values.add(this.resolver.getJCRPath(this.session.getQPath(literal)));
                    log.debug("Coerced " + literal + " into PATH.");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (XMLChar.isValidName(literal)) {
                try {
                    Name n = this.session.getQName(literal);
                    values.add(this.nsMappings.translateName(n));
                    log.debug("Coerced " + literal + " into NAME.");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (literal.indexOf(58) > -1) {
                Calendar c = ISO8601.parse(literal);
                if (c != null) {
                    values.add(DateField.timeToString(c.getTimeInMillis()));
                    log.debug("Coerced " + literal + " into DATE.");
                }
            } else {
                try {
                    values.add(LongField.longToString(Long.parseLong(literal)));
                    log.debug("Coerced " + literal + " into LONG.");
                }
                catch (NumberFormatException e) {
                    try {
                        values.add(DoubleField.doubleToString(Double.parseDouble(literal)));
                        log.debug("Coerced " + literal + " into DOUBLE.");
                    }
                    catch (NumberFormatException e1) {
                        // empty catch block
                    }
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            log.debug("Using literal " + literal + " as is.");
        }
        return values.toArray(new String[values.size()]);
    }
}

