/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.tracer.internal.CallerFilter;

class PrefixExcludeFilter
implements CallerFilter {
    private final List<String> prefixesToExclude;

    public PrefixExcludeFilter(List<String> prefixes) {
        this.prefixesToExclude = Collections.unmodifiableList(prefixes);
    }

    public static PrefixExcludeFilter from(String filter) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String v : filter.split("\\|")) {
            if ((v = v.trim()).isEmpty()) continue;
            prefixes.add(v);
        }
        return new PrefixExcludeFilter(prefixes);
    }

    @Override
    public boolean include(StackTraceElement ste) {
        String className = ste.getClassName();
        for (String prefix : this.prefixesToExclude) {
            if (!className.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    public List<String> getPrefixesToExclude() {
        return this.prefixesToExclude;
    }
}

