/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.PrintServiceExporterConfiguration;
import net.sf.jasperreports.export.PrintServiceReportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;

public class JRPrintServiceExporter
extends JRAbstractExporter<PrintServiceReportConfiguration, PrintServiceExporterConfiguration, ExporterOutput, JRExporterContext>
implements Printable {
    protected static final String PRINT_SERVICE_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.print.service.";
    public static final String EXCEPTION_MESSAGE_KEY_PRINT_SERVICE_NOT_FOUND = "export.print.service.not.found";
    protected JRGraphics2DExporter exporter;
    protected SimpleGraphics2DReportConfiguration grxConfiguration;
    protected int reportIndex;
    private PrintService printService;
    private Boolean[] printStatus;

    public JRPrintServiceExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRPrintServiceExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<PrintServiceExporterConfiguration> getConfigurationInterface() {
        return PrintServiceExporterConfiguration.class;
    }

    @Override
    protected Class<PrintServiceReportConfiguration> getItemConfigurationInterface() {
        return PrintServiceReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        try {
            PrintService[] services;
            Boolean printDialog;
            PrintServiceExporterConfiguration configuration = (PrintServiceExporterConfiguration)this.getCurrentConfiguration();
            PrintServiceAttributeSet printServiceAttributeSet = configuration.getPrintServiceAttributeSet();
            if (printServiceAttributeSet == null) {
                printServiceAttributeSet = new HashPrintServiceAttributeSet();
            }
            boolean displayPageDialog = false;
            boolean displayPageDialogOnlyOnce = false;
            boolean displayPrintDialog = false;
            boolean displayPrintDialogOnlyOnce = false;
            Boolean pageDialog = configuration.isDisplayPageDialog();
            if (pageDialog != null) {
                displayPageDialog = pageDialog;
            }
            Boolean pageDialogOnlyOnce = configuration.isDisplayPageDialogOnlyOnce();
            if (displayPageDialog && pageDialogOnlyOnce != null) {
                displayPageDialogOnlyOnce = pageDialogOnlyOnce;
            }
            if ((printDialog = configuration.isDisplayPrintDialog()) != null) {
                displayPrintDialog = printDialog;
            }
            Boolean printDialogOnlyOnce = configuration.isDisplayPrintDialogOnlyOnce();
            if (displayPrintDialog && printDialogOnlyOnce != null) {
                displayPrintDialogOnlyOnce = printDialogOnlyOnce;
            }
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            JRPrinterAWT.initPrinterJobFields(printerJob);
            printerJob.setPrintable(this);
            this.printStatus = null;
            this.printService = configuration.getPrintService();
            if (this.printService == null && (services = PrintServiceLookup.lookupPrintServices(null, printServiceAttributeSet)).length > 0) {
                this.printService = services[0];
            }
            if (this.printService == null) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_PRINT_SERVICE_NOT_FOUND, (Object[])null);
            }
            try {
                printerJob.setPrintService(this.printService);
            }
            catch (PrinterException e) {
                throw new JRException(e);
            }
            List<ExporterInputItem> items = this.exporterInput.getItems();
            HashPrintRequestAttributeSet printRequestAttributeSet = null;
            if (displayPrintDialogOnlyOnce || displayPageDialogOnlyOnce) {
                printRequestAttributeSet = new HashPrintRequestAttributeSet();
                this.setDefaultPrintRequestAttributeSet(printRequestAttributeSet);
                this.setOrientation(items.get(0).getJasperPrint(), printRequestAttributeSet);
                if (displayPageDialogOnlyOnce) {
                    if (printerJob.pageDialog(printRequestAttributeSet) == null) {
                        return;
                    }
                    displayPageDialog = false;
                }
                if (displayPrintDialogOnlyOnce) {
                    if (!printerJob.printDialog(printRequestAttributeSet)) {
                        this.printStatus = new Boolean[]{Boolean.FALSE};
                        return;
                    }
                    displayPrintDialog = false;
                }
            }
            ArrayList<Boolean> status = new ArrayList<Boolean>();
            this.reportIndex = 0;
            while (this.reportIndex < items.size()) {
                ExporterInputItem item = items.get(this.reportIndex);
                this.setCurrentExporterInputItem(item);
                PrintServiceReportConfiguration lcItemConfiguration = (PrintServiceReportConfiguration)this.getCurrentItemConfiguration();
                this.exporter = new JRGraphics2DExporter(this.jasperReportsContext);
                this.exporter.setExporterInput(new SimpleExporterInput(this.jasperPrint));
                this.grxConfiguration = new SimpleGraphics2DReportConfiguration();
                this.grxConfiguration.setProgressMonitor(lcItemConfiguration.getProgressMonitor());
                this.grxConfiguration.setOffsetX(lcItemConfiguration.getOffsetX());
                this.grxConfiguration.setOffsetY(lcItemConfiguration.getOffsetY());
                this.grxConfiguration.setZoomRatio(lcItemConfiguration.getZoomRatio());
                this.grxConfiguration.setExporterFilter(this.filter);
                this.grxConfiguration.setMinimizePrinterJobSize(lcItemConfiguration.isMinimizePrinterJobSize());
                if (displayPrintDialog || displayPageDialog || !displayPrintDialogOnlyOnce && !displayPageDialogOnlyOnce) {
                    printRequestAttributeSet = new HashPrintRequestAttributeSet();
                    this.setDefaultPrintRequestAttributeSet(printRequestAttributeSet);
                    this.setOrientation(this.jasperPrint, printRequestAttributeSet);
                }
                try {
                    int endPageIndex;
                    JRAbstractExporter.PageRange pageRange = this.getPageRange();
                    int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                    int n = endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? this.jasperPrint.getPages().size() - 1 : pageRange.getEndPageIndex();
                    if (items.size() == 1) {
                        printRequestAttributeSet.add(new PageRanges(startPageIndex + 1, endPageIndex + 1));
                    }
                    printerJob.setJobName("JasperReports - " + this.jasperPrint.getName());
                    if (displayPageDialog) {
                        printerJob.pageDialog(printRequestAttributeSet);
                    }
                    if (displayPrintDialog) {
                        if (printerJob.printDialog(printRequestAttributeSet)) {
                            status.add(Boolean.TRUE);
                            printerJob.print(printRequestAttributeSet);
                        } else {
                            status.add(Boolean.FALSE);
                        }
                    } else {
                        PageFormat pageFormat = printerJob.defaultPage();
                        Paper paper = pageFormat.getPaper();
                        switch (this.jasperPrint.getOrientation()) {
                            case LANDSCAPE: {
                                pageFormat.setOrientation(0);
                                paper.setSize(this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                                break;
                            }
                            default: {
                                pageFormat.setOrientation(1);
                                paper.setSize(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                            }
                        }
                        pageFormat.setPaper(paper);
                        printerJob.setPrintable(this, pageFormat);
                        printerJob.print(printRequestAttributeSet);
                    }
                }
                catch (PrinterException e) {
                    throw new JRException(e);
                }
                ++this.reportIndex;
            }
            this.printStatus = status.toArray(new Boolean[status.size()]);
            this.printService = printerJob.getPrintService();
        }
        finally {
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (Thread.interrupted()) {
            throw new PrinterException("Current thread interrupted.");
        }
        if (pageIndex < 0 || pageIndex >= this.jasperPrint.getPages().size()) {
            return 1;
        }
        SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
        output.setGraphics2D((Graphics2D)graphics);
        this.exporter.setExporterOutput(output);
        this.grxConfiguration.setPageIndex(pageIndex);
        this.exporter.setConfiguration(this.grxConfiguration);
        try {
            this.exporter.exportReport();
        }
        catch (JRException e) {
            throw new PrinterException(e.getMessage());
        }
        return 0;
    }

    private void setOrientation(JasperPrint jPrint, PrintRequestAttributeSet printRequestAttributeSet) {
        if (!printRequestAttributeSet.containsKey(MediaPrintableArea.class)) {
            int printableHeight;
            int printableWidth;
            switch (jPrint.getOrientation()) {
                case LANDSCAPE: {
                    printableWidth = jPrint.getPageHeight();
                    printableHeight = jPrint.getPageWidth();
                    break;
                }
                default: {
                    printableWidth = jPrint.getPageWidth();
                    printableHeight = jPrint.getPageHeight();
                }
            }
            printRequestAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, (float)printableWidth / 72.0f, (float)printableHeight / 72.0f, 25400));
        }
        if (!printRequestAttributeSet.containsKey(OrientationRequested.class)) {
            OrientationRequested orientation;
            switch (jPrint.getOrientation()) {
                case LANDSCAPE: {
                    orientation = OrientationRequested.LANDSCAPE;
                    break;
                }
                default: {
                    orientation = OrientationRequested.PORTRAIT;
                }
            }
            printRequestAttributeSet.add(orientation);
        }
    }

    private void setDefaultPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        PrintRequestAttributeSet configPrintRequestAttributeSet = ((PrintServiceExporterConfiguration)this.getCurrentConfiguration()).getPrintRequestAttributeSet();
        if (configPrintRequestAttributeSet != null) {
            printRequestAttributeSet.addAll(configPrintRequestAttributeSet);
        }
    }

    public static boolean checkAvailablePrinters() {
        PrintService[] ss = PrinterJob.lookupPrintServices();
        for (int i = 0; i < ss.length; ++i) {
            Attribute[] att = ss[i].getAttributes().toArray();
            for (int j = 0; j < att.length; ++j) {
                if (!att[j].equals(PrinterIsAcceptingJobs.ACCEPTING_JOBS)) continue;
                return true;
            }
        }
        return false;
    }

    public Boolean[] getPrintStatus() {
        return this.printStatus;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    @Override
    public String getExporterKey() {
        return null;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return PRINT_SERVICE_EXPORTER_PROPERTIES_PREFIX;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext {
        protected ExporterContext() {
            super(JRPrintServiceExporter.this);
        }
    }
}

