/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;

public class MapHtmlResourceHandler
implements HtmlResourceHandler {
    private HtmlResourceHandler parentHandler;
    private Map<String, byte[]> resourcesMap;

    public MapHtmlResourceHandler(HtmlResourceHandler parentHandler, Map<String, byte[]> resourcesMap) {
        this.parentHandler = parentHandler;
        this.resourcesMap = resourcesMap;
    }

    public MapHtmlResourceHandler(HtmlResourceHandler parentHandler) {
        this(parentHandler, new HashMap<String, byte[]>());
    }

    public MapHtmlResourceHandler(Map<String, byte[]> resourcesMap) {
        this(null, resourcesMap);
    }

    public MapHtmlResourceHandler() {
        this((HtmlResourceHandler)null);
    }

    @Override
    public String getResourcePath(String id) {
        if (this.parentHandler == null) {
            return id;
        }
        return this.parentHandler.getResourcePath(id);
    }

    @Override
    public void handleResource(String id, byte[] data) {
        if (this.parentHandler != null) {
            this.parentHandler.handleResource(id, data);
        }
        if (this.resourcesMap != null) {
            this.resourcesMap.put(id, data);
        }
    }

    public Map<String, byte[]> getResourcesMap() {
        return this.resourcesMap;
    }
}

