/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.DefaultTaskJobDetailFactory;
import org.apache.synapse.task.DefaultTaskTriggerFactory;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.Task;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskJobDetailFactory;
import org.apache.synapse.task.TaskTriggerFactory;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.utils.Key;

public class TaskScheduler {
    private static Log log = LogFactory.getLog(TaskScheduler.class);
    private Scheduler scheduler;
    private boolean initialized = false;
    private TaskTriggerFactory triggerFactory = new DefaultTaskTriggerFactory();
    private TaskJobDetailFactory jobDetailFactory = new DefaultTaskJobDetailFactory();
    public static final String QUARTZ_CONF = "quartz.conf";
    private String name;

    public TaskScheduler(String name) {
        this.name = name;
    }

    public void init(Properties properties) {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        if (properties != null) {
            String quartzConf = properties.getProperty(QUARTZ_CONF);
            try {
                if (quartzConf != null && !"".equals(quartzConf)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Initiating a Scheduler with configuration : " + quartzConf));
                    }
                    sf.initialize(quartzConf);
                }
            }
            catch (SchedulerException e) {
                throw new SynapseTaskException("Error initiating scheduler factory " + sf + "with configuration loaded from " + quartzConf, e, log);
            }
        }
        try {
            if (this.name != null) {
                this.scheduler = sf.getScheduler(this.name);
            }
            if (this.scheduler == null) {
                this.scheduler = sf.getScheduler();
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error getting a  scheduler instance form scheduler factory " + sf, e, log);
        }
        this.initialized = true;
        this.start();
    }

    public void start() {
        this.assertInitialized();
        try {
            if (!this.scheduler.isStarted()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Starting a Scheduler : [ " + this.scheduler.getMetaData() + " ]"));
                }
                this.scheduler.start();
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error starting scheduler ", e, log);
        }
    }

    public void pauseAll() {
        try {
            this.assertInitialized();
            this.assertStarted();
            this.scheduler.pauseAll();
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error pausing tasks ", e, log);
        }
    }

    public void resumeAll() {
        try {
            this.assertInitialized();
            this.assertStarted();
            this.scheduler.resumeAll();
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error resuming tasks ", e, log);
        }
    }

    public void scheduleTask(TaskDescription taskDescription, Map<String, Object> resources, Class<? extends Job> jobClass) {
        this.assertInitialized();
        this.assertStarted();
        if (taskDescription == null) {
            throw new SynapseTaskException("Task Description cannot be found", log);
        }
        if (jobClass == null) {
            throw new SynapseTaskException("Job Class cannot be found", log);
        }
        if (this.triggerFactory == null) {
            throw new SynapseTaskException("TriggerFactory cannot be found", log);
        }
        if (this.jobDetailFactory == null) {
            throw new SynapseTaskException("JobDetailFactory cannot be found", log);
        }
        Trigger trigger = this.triggerFactory.createTrigger(taskDescription);
        if (trigger == null) {
            throw new SynapseTaskException("Trigger cannot be created from : " + taskDescription, log);
        }
        JobDetail jobDetail = this.jobDetailFactory.createJobDetail(taskDescription, resources, jobClass);
        if (jobDetail == null) {
            throw new SynapseTaskException("JobDetail cannot be created from : " + taskDescription + " and job class " + jobClass.getName(), log);
        }
        try {
            if (taskDescription.getCount() != 0) {
                if (!this.isTaskAlreadyRunning(jobDetail.getKey())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Scheduling job : " + jobDetail + " with trigger " + trigger));
                    }
                    this.scheduler.scheduleJob(jobDetail, trigger);
                } else {
                    log.warn((Object)("Did not schedule the job : " + jobDetail + ". The job is already running."));
                }
            } else {
                log.warn((Object)("Did not schedule the job : " + jobDetail + ". Job count is zero."));
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error scheduling job : " + jobDetail + " with trigger " + trigger);
        }
    }

    public void scheduleTask(TaskDescription taskDescription, Map<String, Object> resources, Class<? extends Job> jobClass, Task task) {
        this.assertInitialized();
        this.assertStarted();
        if (taskDescription == null) {
            throw new SynapseTaskException("Task Description cannot be found", log);
        }
        if (jobClass == null) {
            throw new SynapseTaskException("Job Class cannot be found", log);
        }
        if (this.triggerFactory == null) {
            throw new SynapseTaskException("TriggerFactory cannot be found", log);
        }
        if (this.jobDetailFactory == null) {
            throw new SynapseTaskException("JobDetailFactory cannot be found", log);
        }
        Trigger trigger = this.triggerFactory.createTrigger(taskDescription);
        if (trigger == null) {
            throw new SynapseTaskException("Trigger cannot be created from : " + taskDescription, log);
        }
        JobDetail jobDetail = this.jobDetailFactory.createJobDetail(taskDescription, resources, jobClass);
        if (jobDetail == null) {
            throw new SynapseTaskException("JobDetail cannot be created from : " + taskDescription + " and job class " + jobClass.getName(), log);
        }
        jobDetail.getJobDataMap().put("Instance", (Object)task);
        try {
            if (taskDescription.getCount() != 0) {
                if (!this.isTaskAlreadyRunning(jobDetail.getKey())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Scheduling job : " + jobDetail + " with trigger " + trigger));
                    }
                    this.scheduler.scheduleJob(jobDetail, trigger);
                } else {
                    log.warn((Object)("Did not schedule the job : " + jobDetail + ". The job is already running."));
                }
            } else {
                log.warn((Object)("Did not schedule the job : " + jobDetail + ". Job count is zero."));
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error scheduling job : " + jobDetail + " with trigger " + trigger);
        }
    }

    public void shutDown() {
        if (this.isInitialized()) {
            try {
                if (this.scheduler != null && this.scheduler.isStarted()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ShuttingDown Task Scheduler : " + this.scheduler.getMetaData()));
                    }
                    this.scheduler.shutdown(true);
                }
                this.initialized = false;
            }
            catch (SchedulerException e) {
                throw new SynapseTaskException("Error ShuttingDown task scheduler ", e, log);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void deleteTask(String name, String group) {
        this.assertInitialized();
        this.assertStarted();
        if (name == null || "".equals(name)) {
            throw new SynapseTaskException("Task Name can not be null", log);
        }
        if (group == null || "".equals(group)) {
            group = "synapse.simple.quartz";
            if (log.isDebugEnabled()) {
                log.debug((Object)"Task group is null or empty , using default group :synapse.simple.quartz");
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting a Job with [ Name :" + name + " ] [ Group :" + group + " ]"));
            }
            this.scheduler.deleteJob(new JobKey(name, group));
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error deleting a job with  [ Name :" + name + " ] [ Group :" + group + " ]");
        }
    }

    public int getRunningTaskCount() {
        int runningTasks = 0;
        try {
            if (this.scheduler != null) {
                runningTasks = this.scheduler.getCurrentlyExecutingJobs().size();
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Error querying currently executing jobs", (Throwable)e);
        }
        return runningTasks;
    }

    private boolean isTaskAlreadyRunning(JobKey jobKey) throws SchedulerException {
        List currentJobs = this.scheduler.getCurrentlyExecutingJobs();
        for (JobExecutionContext jobCtx : currentJobs) {
            JobKey currentJobKey = jobCtx.getJobDetail().getKey();
            if (currentJobKey.compareTo((Key)jobKey) != 0) continue;
            log.warn((Object)("The job " + jobKey.getName() + " is already running"));
            return true;
        }
        return false;
    }

    public void setTriggerFactory(TaskTriggerFactory triggerFactory) {
        this.triggerFactory = triggerFactory;
    }

    public void setJobDetailFactory(TaskJobDetailFactory jobDetailFactory) {
        this.jobDetailFactory = jobDetailFactory;
    }

    public String toString() {
        StringBuffer schedulerMetaData = new StringBuffer();
        if (this.scheduler != null) {
            schedulerMetaData = schedulerMetaData.append("[ Scheduler : ").append(this.scheduler).append(" ]");
        }
        return "[ TaskScheduler[ Name : " + this.name + " ]" + schedulerMetaData + " ]";
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new SynapseTaskException("Scheduler has not been initialled yet", log);
        }
    }

    private void assertStarted() {
        try {
            if (!this.scheduler.isStarted()) {
                throw new SynapseTaskException("Scheduler has not been started yet", log);
            }
        }
        catch (SchedulerException e) {
            throw new SynapseTaskException("Error determine start state of the scheduler ", e, log);
        }
    }
}

