/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DataSourceRepositoryManager;

public class RepositoryBasedDataSourceFinder {
    private static final Log log = LogFactory.getLog(RepositoryBasedDataSourceFinder.class);
    private DataSourceRepositoryManager dataSourceRepositoryManager;
    private boolean initialized;

    public void init(DataSourceRepositoryManager dataSourceRepositoryManager) {
        this.dataSourceRepositoryManager = dataSourceRepositoryManager;
        this.initialized = true;
    }

    public DataSource find(String name) {
        this.assertInitialized();
        if (name == null || "".equals(name)) {
            throw new SynapseCommonsException("DataSource name cannot be found.", log);
        }
        return this.dataSourceRepositoryManager.getDataSource(name);
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new SynapseCommonsException("RepositoryBasedDataSourceFinder has not been initialized with a 'DataSourceRepositoryManager' instance ", log);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

