/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class ControlledByteBuffer {
    private ByteBuffer byteBuffer;
    private AtomicBoolean inputMode = new AtomicBoolean(true);

    public ControlledByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public boolean setInputMode() {
        return this.inputMode.compareAndSet(false, true);
    }

    public boolean setOutputMode() {
        return this.inputMode.compareAndSet(true, false);
    }

    public void forceSetInputMode() {
        this.inputMode = new AtomicBoolean(true);
    }

    public void flip() {
        this.byteBuffer.flip();
    }

    public void clear() {
        this.byteBuffer.clear();
    }

    public void compact() {
        this.byteBuffer.compact();
    }

    public int position() {
        return this.byteBuffer.position();
    }

    public void put(byte b) {
        this.byteBuffer.put(b);
    }

    public void putInt(int value) {
        this.byteBuffer.putInt(value);
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        return this.byteBuffer.put(src, offset, length);
    }

    public boolean hasRemaining() {
        return this.byteBuffer.hasRemaining();
    }

    public byte get() {
        return this.byteBuffer.get();
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        return this.byteBuffer.get(dst, offset, length);
    }

    public int remaining() {
        return this.byteBuffer.remaining();
    }
}

