/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn.logging;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;

public class LoggingClientEventHandler
implements NHttpClientEventHandler {
    private final Log log;
    private final NHttpClientEventHandler handler;

    public LoggingClientEventHandler(NHttpClientEventHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler must not be null");
        }
        this.handler = handler;
        this.log = LogFactory.getLog(handler.getClass());
    }

    public void connected(NHttpClientConnection conn, Object attachment) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Connected (" + attachment + ")"));
        }
        this.handler.connected(conn, attachment);
    }

    public void closed(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Closed"));
        }
        this.handler.closed(conn);
    }

    public void endOfInput(NHttpClientConnection conn) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Closed at remote end"));
        }
        this.handler.endOfInput(conn);
    }

    public void exception(NHttpClientConnection conn, Exception ex) {
        this.handler.exception(conn, ex);
    }

    public void requestReady(NHttpClientConnection conn) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": InRequest ready"));
        }
        this.handler.requestReady(conn);
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Output ready"));
        }
        this.handler.outputReady(conn, encoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Content encoder " + encoder));
        }
    }

    public void responseReceived(NHttpClientConnection conn) throws IOException, HttpException {
        HttpResponse response = conn.getHttpResponse();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + " : " + response.getStatusLine()));
        }
        this.handler.responseReceived(conn);
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Input ready"));
        }
        this.handler.inputReady(conn, decoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Content decoder " + decoder));
        }
    }

    public void timeout(NHttpClientConnection conn) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Timeout"));
        }
        this.handler.timeout(conn);
    }
}

