/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.validation;

import java.util.HashSet;
import java.util.Set;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.ValidationRule;
import org.owasp.esapi.errors.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseValidationRule
implements ValidationRule {
    private String typeName = null;
    protected boolean allowNull = false;
    protected Encoder encoder = null;

    private BaseValidationRule() {
    }

    public BaseValidationRule(String typeName) {
        this();
        this.setEncoder(ESAPI.encoder());
        this.setTypeName(typeName);
    }

    public BaseValidationRule(String typeName, Encoder encoder) {
        this();
        this.setEncoder(encoder);
        this.setTypeName(typeName);
    }

    @Override
    public void setAllowNull(boolean flag) {
        this.allowNull = flag;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public final void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public final void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public void assertValid(String context, String input) throws ValidationException {
        this.getValid(context, input, null);
    }

    @Override
    public Object getValid(String context, String input, ValidationErrorList errorList) throws ValidationException {
        Object valid = null;
        try {
            valid = this.getValid(context, input);
        }
        catch (ValidationException e) {
            errorList.addError(context, e);
        }
        return valid;
    }

    @Override
    public Object getSafe(String context, String input) {
        Object valid = null;
        try {
            valid = this.getValid(context, input);
        }
        catch (ValidationException e) {
            return this.sanitize(context, input);
        }
        return valid;
    }

    protected abstract Object sanitize(String var1, String var2);

    @Override
    public boolean isValid(String context, String input) {
        boolean valid = false;
        try {
            this.getValid(context, input);
            valid = true;
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    @Override
    public String whitelist(String input, char[] whitelist) {
        return this.whitelist(input, BaseValidationRule.charArrayToSet(whitelist));
    }

    @Override
    public String whitelist(String input, Set<Character> whitelist) {
        StringBuilder stripped = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!whitelist.contains(Character.valueOf(c))) continue;
            stripped.append(c);
        }
        return stripped.toString();
    }

    public static Set<Character> charArrayToSet(char[] array) {
        HashSet<Character> toReturn = new HashSet<Character>(array.length);
        for (char c : array) {
            toReturn.add(Character.valueOf(c));
        }
        return toReturn;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }
}

