/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.dispatcher;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import javax.activation.DataSource;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.listener.ContextListenerUtils;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.databinding.OMBlock;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.DataSourceBlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.factory.OMBlockFactory;
import org.apache.axis2.jaxws.message.factory.SOAPEnvelopeBlockFactory;
import org.apache.axis2.jaxws.message.factory.SourceBlockFactory;
import org.apache.axis2.jaxws.message.factory.XMLStringBlockFactory;
import org.apache.axis2.jaxws.message.util.XMLFaultUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.EndpointCallback;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.InvocationHelper;
import org.apache.axis2.jaxws.server.dispatcher.JavaDispatcher;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.DataSourceFormatter;
import org.apache.axis2.jaxws.utility.ExecutorFactory;
import org.apache.axis2.jaxws.utility.SingleThreadedExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderDispatcher
extends JavaDispatcher {
    private static Log log = LogFactory.getLog(ProviderDispatcher.class);
    private BlockFactory _blockFactory = null;
    private Class _providerType = null;
    private Provider providerInstance = null;
    private Message message = null;
    private EndpointDescription endpointDesc = null;

    public ProviderDispatcher(Class _class, Object serviceInstance) {
        super(_class, serviceInstance);
    }

    @Override
    public MessageContext invoke(MessageContext request) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing to invoke javax.xml.ws.Provider based endpoint");
            log.debug((Object)"Invocation pattern: two way, sync");
        }
        this.initialize(request);
        this.providerInstance = this.getProviderInstance();
        Object param = this.createRequestParameters(request);
        if (log.isDebugEnabled()) {
            Class<?> providerType = this.getProviderType();
            Object input = providerType.cast(param);
            log.debug((Object)("Invoking Provider<" + providerType.getName() + ">"));
            if (input != null) {
                log.debug((Object)("Parameter type: " + input.getClass().getName()));
            } else {
                log.debug((Object)"Parameter is NULL");
            }
        }
        boolean faultThrown = false;
        Throwable fault = null;
        Object[] input = new Object[]{param};
        Object responseParamValue = null;
        Method target = null;
        try {
            target = this.getJavaMethod();
            responseParamValue = this.invokeTargetOperation(target, input);
        }
        catch (Throwable e) {
            fault = ClassUtils.getRootCause(e);
            faultThrown = true;
        }
        MessageContext responseMsgCtx = null;
        if (faultThrown) {
            responseMsgCtx = this.createFaultResponse(request, fault);
            ProviderDispatcher.setExceptionProperties(responseMsgCtx, target, fault);
        } else if (responseParamValue == null && MessageContextUtils.getJaxwsProviderInterpretNullOneway(request) && !request.getAxisMessageContext().getAxisService().isWsdlFound()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("detected null return from Provider, " + target + "and operation is not wsdl defined and interpretNullAsOneway property is true."));
            }
            responseMsgCtx = null;
        } else {
            responseMsgCtx = this.createResponse(request, input, responseParamValue);
        }
        return responseMsgCtx;
    }

    @Override
    public void invokeOneWay(MessageContext request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing to invoke javax.xml.ws.Provider based endpoint");
            log.debug((Object)"Invocation pattern: one way");
        }
        this.initialize(request);
        this.providerInstance = this.getProviderInstance();
        Object param = this.createRequestParameters(request);
        if (log.isDebugEnabled()) {
            Class<?> providerType = this.getProviderType();
            Object input = providerType.cast(param);
            log.debug((Object)("Invoking Provider<" + providerType.getName() + ">"));
            if (input != null) {
                log.debug((Object)("Parameter type: " + input.getClass().getName()));
            } else {
                log.debug((Object)"Parameter is NULL");
            }
        }
        ExecutorFactory ef = (ExecutorFactory)FactoryRegistry.getFactory(ExecutorFactory.class);
        Executor executor = ef.getExecutorInstance(1);
        Boolean disable = (Boolean)request.getProperty("serverDisableThreadSwitch");
        if (disable != null && disable.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Server side thread switch disabled.  Setting Executor to the SingleThreadedExecutor.");
            }
            executor = new SingleThreadedExecutor();
        }
        Method m = this.getJavaMethod();
        Object[] params = new Object[]{param};
        EndpointInvocationContext eic = (EndpointInvocationContext)request.getInvocationContext();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        JavaDispatcher.AsyncInvocationWorker worker = new JavaDispatcher.AsyncInvocationWorker(m, params, cl, eic);
        FutureTask task = new FutureTask(worker);
        executor.execute(task);
    }

    @Override
    public void invokeAsync(MessageContext request, EndpointCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing to invoke javax.xml.ws.Provider based endpoint");
            log.debug((Object)"Invocation pattern: two way, async");
        }
        this.initialize(request);
        this.providerInstance = this.getProviderInstance();
        Object param = this.createRequestParameters(request);
        if (log.isDebugEnabled()) {
            Class<?> providerType = this.getProviderType();
            Object input = providerType.cast(param);
            log.debug((Object)("Invoking Provider<" + providerType.getName() + ">"));
            if (input != null) {
                log.debug((Object)("Parameter type: " + input.getClass().getName()));
            } else {
                log.debug((Object)"Parameter is NULL");
            }
        }
        ExecutorFactory ef = (ExecutorFactory)FactoryRegistry.getFactory(ExecutorFactory.class);
        Executor executor = ef.getExecutorInstance(1);
        Boolean disable = (Boolean)request.getProperty("serverDisableThreadSwitch");
        if (disable != null && disable.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Server side thread switch disabled.  Setting Executor to the SingleThreadedExecutor.");
            }
            executor = new SingleThreadedExecutor();
        }
        Method m = this.getJavaMethod();
        Object[] params = new Object[]{param};
        EndpointInvocationContext eic = (EndpointInvocationContext)request.getInvocationContext();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        JavaDispatcher.AsyncInvocationWorker worker = new JavaDispatcher.AsyncInvocationWorker(m, params, cl, eic);
        FutureTask task = new FutureTask(worker);
        executor.execute(task);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createRequestParameters(MessageContext request) {
        Class<?> providerType = this.getProviderType();
        EndpointDescription endpointDesc = request.getEndpointDescription();
        Object requestParamValue = null;
        Message message = request.getMessage();
        if (message == null) return requestParamValue;
        if (endpointDesc.isMTOMEnabled()) {
            message.setMTOMEnabled(true);
        }
        Protocol messageProtocol = message.getProtocol();
        BlockFactory factory = this.createBlockFactory(providerType);
        Service.Mode providerServiceMode = endpointDesc.getServiceMode();
        if (providerServiceMode != null && providerServiceMode == Service.Mode.MESSAGE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Provider type is " + providerType.getClass().getName()));
            }
            if (providerType.equals(SOAPMessage.class) && log.isDebugEnabled()) {
                log.debug((Object)("Number Message attachments=" + message.getAttachmentIDs().size()));
            }
            if (providerType.equals(OMElement.class)) {
                ContextListenerUtils.registerProviderOMListener(request);
                requestParamValue = message.getAsOMElement();
            } else {
                requestParamValue = message.getValue(null, factory);
            }
        } else {
            Block block = message.getBodyBlock(null, factory);
            if (block != null) {
                try {
                    requestParamValue = block.getBusinessObject(true);
                    if (!(requestParamValue instanceof OMBlock)) return requestParamValue;
                    if (!log.isDebugEnabled()) return ((OMBlock)requestParamValue).getOMElement();
                    log.debug((Object)"request parameter business object is OMBlock.  Now retrieving OMElement from OMBlock.");
                    return ((OMBlock)requestParamValue).getOMElement();
                }
                catch (WebServiceException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
            }
            if (!log.isDebugEnabled()) return null;
            log.debug((Object)"No body blocks in SOAPMessage, Calling provider method with null input parameters");
            return null;
        }
        if (requestParamValue != null) return requestParamValue;
        if (!log.isDebugEnabled()) return requestParamValue;
        log.debug((Object)"There are no elements to unmarshal.  ProviderDispatch will pass a null as input");
        return requestParamValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext createResponse(MessageContext request, Object[] input, Object output) {
        Message m;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start createResponse");
        }
        EndpointDescription endpointDesc = null;
        try {
            endpointDesc = request.getEndpointDescription();
            Service.Mode mode = endpointDesc.getServiceMode();
            m = this.createMessageFromValue(output, request.getMessage().getProtocol(), mode);
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Throwable caught");
                log.debug((Object)("Throwable=" + t));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)t);
        }
        MessageContext response = null;
        try {
            if (endpointDesc.isMTOMEnabled()) {
                m.setMTOMEnabled(true);
            }
            if (!m.isFault()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Non-Fault Response MessageContext is created.");
                }
                response = MessageContextUtils.createResponseMessageContext(request);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fault Response MessageContext is created.");
                }
                response = MessageContextUtils.createFaultMessageContext(request);
            }
            this.initMessageContext(response, m, output);
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Throwable caught creating Response MessageContext");
                log.debug((Object)("Throwable=" + e));
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"End createResponse");
            }
        }
        return response;
    }

    protected void initMessageContext(MessageContext responseMsgCtx, Message m, Object output) {
        responseMsgCtx.setMessage(m);
        if (output instanceof DataSource) {
            responseMsgCtx.setProperty("messageFormatter", new DataSourceFormatter(((DataSource)output).getContentType()));
        }
    }

    @Override
    public MessageContext createFaultResponse(MessageContext request, Throwable fault) {
        Message m;
        Throwable faultMessage;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Create XMLFault for createFaultResponse");
        }
        if ((faultMessage = InvocationHelper.determineMappedException(fault, request)) != null) {
            fault = faultMessage;
        }
        try {
            EndpointDescription endpointDesc = request.getEndpointDescription();
            Service.Mode mode = endpointDesc.getServiceMode();
            XMLFault xmlFault = MethodMarshallerUtils.createXMLFaultFromSystemException(fault);
            m = this.createMessageFromValue(xmlFault, request.getMessage().getProtocol(), mode);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        MessageContext response = MessageContextUtils.createFaultMessageContext(request);
        response.setMessage(m);
        return response;
    }

    public Provider getProvider() throws Exception {
        Provider p = this.getProviderInstance();
        this.setProvider(p);
        return p;
    }

    public void setProvider(Provider _provider) {
        this.providerInstance = _provider;
    }

    public Message getMessage() throws Exception {
        return this.message;
    }

    public void setMessage(Message msg) {
        this.message = msg;
    }

    private Message createMessageFromValue(Object value, Protocol protocol, Service.Mode mode) throws Exception {
        MessageFactory msgFactory = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
        Message message = null;
        if (value != null) {
            Class<?> providerType = this.getProviderType();
            BlockFactory factory = this.createBlockFactory(providerType);
            if (value instanceof XMLFault) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Creating message from XMLFault");
                }
                message = msgFactory.create(protocol);
                message.setXMLFault((XMLFault)value);
            } else if (mode != null && mode == Service.Mode.MESSAGE) {
                if (value instanceof SOAPMessage) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Creating message from SOAPMessage");
                    }
                    message = msgFactory.createFrom((SOAPMessage)value);
                } else if (value instanceof SOAPEnvelope) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Creating message from OMElement");
                    }
                    message = msgFactory.createFrom((OMElement)((SOAPEnvelope)value), protocol);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating message using " + factory));
                    }
                    Block block = factory.createFrom(value, null, null);
                    message = msgFactory.createFrom(block, null, protocol);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating message (payload) using " + factory));
                }
                Block block = factory.createFrom(value, null, null);
                message = msgFactory.create(protocol);
                if (XMLFaultUtils.containsFault(block)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"The response block created contained a fault.  Converting to an XMLFault object.");
                    }
                    XMLFault fault = XMLFaultUtils.createXMLFault(block, message.getProtocol());
                    message.setXMLFault(fault);
                } else {
                    message.setBodyBlock(block);
                }
            }
        }
        if (message == null) {
            message = msgFactory.create(protocol);
        }
        return message;
    }

    private Provider getProviderInstance() {
        Class<?> clazz = this.getProviderType();
        if (!this.isValidProviderType(clazz)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"InvalidProvider", (String)clazz.getName()));
        }
        Provider provider = null;
        if (clazz == String.class) {
            provider = (Provider)this.serviceInstance;
        } else if (clazz == Source.class) {
            provider = (Provider)this.serviceInstance;
        } else if (clazz == SOAPMessage.class) {
            provider = (Provider)this.serviceInstance;
        } else if (clazz == DataSource.class) {
            provider = (Provider)this.serviceInstance;
        } else if (clazz == OMElement.class) {
            provider = (Provider)this.serviceInstance;
        }
        if (provider == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"InvalidProviderCreate", (String)clazz.getName()));
        }
        return provider;
    }

    private Class<?> getProviderType() {
        Type[] giTypes;
        if (this._providerType != null) {
            return this._providerType;
        }
        Class providerType = null;
        for (Type giType : giTypes = this.serviceImplClass.getGenericInterfaces()) {
            ParameterizedType paramType = null;
            try {
                paramType = (ParameterizedType)giType;
            }
            catch (ClassCastException e) {
                continue;
            }
            Class interfaceName = (Class)paramType.getRawType();
            if (interfaceName != Provider.class) continue;
            if (paramType.getActualTypeArguments().length > 1) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"pTypeErr"));
            }
            providerType = (Class)paramType.getActualTypeArguments()[0];
        }
        this._providerType = providerType;
        return providerType;
    }

    private boolean isValidProviderType(Class clazz) {
        boolean valid;
        boolean bl = valid = clazz == String.class || clazz == SOAPMessage.class || clazz == Source.class || clazz == DataSource.class || clazz == OMElement.class;
        if (!valid && log.isDebugEnabled()) {
            log.debug((Object)("Class " + clazz.getName() + " is not a valid Provider<T> type"));
        }
        return valid;
    }

    private BlockFactory createBlockFactory(Class type) {
        if (this._blockFactory != null) {
            return this._blockFactory;
        }
        if (type.equals(String.class)) {
            this._blockFactory = (XMLStringBlockFactory)FactoryRegistry.getFactory(XMLStringBlockFactory.class);
        } else if (type.equals(DataSource.class)) {
            this._blockFactory = (DataSourceBlockFactory)FactoryRegistry.getFactory(DataSourceBlockFactory.class);
        } else if (type.equals(Source.class)) {
            this._blockFactory = (SourceBlockFactory)FactoryRegistry.getFactory(SourceBlockFactory.class);
        } else if (type.equals(SOAPMessage.class)) {
            this._blockFactory = (SOAPEnvelopeBlockFactory)FactoryRegistry.getFactory(SOAPEnvelopeBlockFactory.class);
        } else if (type.equals(OMElement.class)) {
            this._blockFactory = (OMBlockFactory)FactoryRegistry.getFactory(OMBlockFactory.class);
        } else {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"bFactoryErr", (String)type.getName()));
        }
        return this._blockFactory;
    }

    protected Method getJavaMethod() {
        Method m = null;
        try {
            m = this.providerInstance.getClass().getMethod("invoke", this.getProviderType());
        }
        catch (SecurityException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return m;
    }

    protected void initialize(MessageContext mc) {
        mc.setOperationName(mc.getAxisMessageContext().getAxisOperation().getName());
        this.endpointDesc = mc.getEndpointDescription();
        if (this.endpointDesc.isMTOMEnabled()) {
            mc.getMessage().setMTOMEnabled(true);
        }
        ContextUtils.addWSDLProperties_provider(mc);
    }
}

