/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.axis2.clustering.tribes.ClassLoaderUtil;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.group.RpcMessage;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.Logs;

public class Axis2GroupChannel
extends GroupChannel {
    public void messageReceived(ChannelMessage msg) {
        if (msg == null) {
            return;
        }
        try {
            Object fwd;
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Received msg:" + new UniqueId(msg.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " from " + msg.getAddress().getName()));
            }
            if ((msg.getOptions() & 1) == 1) {
                fwd = new ByteMessage(msg.getMessage().getBytes());
            } else {
                try {
                    fwd = XByteBuffer.deserialize((byte[])msg.getMessage().getBytesDirect(), (int)0, (int)msg.getMessage().getLength(), (ClassLoader[])ClassLoaderUtil.getClassLoaders());
                }
                catch (Exception sx) {
                    log.error((Object)("Unable to deserialize message:" + msg), (Throwable)sx);
                    return;
                }
            }
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Receive Message:" + new UniqueId(msg.getUniqueId()) + " is " + fwd));
            }
            Member source = msg.getAddress();
            boolean rx = false;
            boolean delivered = false;
            for (Object channelListener1 : this.channelListeners) {
                ChannelListener channelListener = (ChannelListener)channelListener1;
                if (channelListener == null || !channelListener.accept((Serializable)fwd, source)) continue;
                channelListener.messageReceived((Serializable)fwd, source);
                delivered = true;
                if (!(channelListener instanceof RpcChannel)) continue;
                rx = true;
            }
            if (!rx && fwd instanceof RpcMessage) {
                this.sendNoRpcChannelReply((RpcMessage)fwd, source);
            }
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel delivered[" + delivered + "] id:" + new UniqueId(msg.getUniqueId())));
            }
        }
        catch (Exception x) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Error receiving message:", (Throwable)x);
            }
            throw new RemoteProcessException("Exception:" + x.getMessage(), (Throwable)x);
        }
    }
}

