/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.TemplateEndpoint;

public class Template
implements SynapseArtifact {
    private OMElement element = null;
    private String name = null;
    private List<String> parameters = new ArrayList<String>();
    private String fileName = null;
    private String description = null;

    public Endpoint create(TemplateEndpoint templateEndpoint, Properties properties) {
        OMElement clonedElement = this.element.cloneOMElement();
        this.replaceElement(templateEndpoint, clonedElement);
        return EndpointFactory.getEndpointFromElement(clonedElement, false, properties);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void addParameter(String name) {
        this.parameters.add(name);
    }

    public void setElement(OMElement element) {
        this.element = element;
    }

    public OMElement getElement() {
        return this.element;
    }

    private void replaceElement(TemplateEndpoint templateEndpoint, OMElement element) {
        String replace;
        Iterator attributesItr = element.getAllAttributes();
        while (attributesItr.hasNext()) {
            OMAttribute attribute = (OMAttribute)attributesItr.next();
            String replace2 = this.replace(attribute.getAttributeValue(), templateEndpoint);
            if (replace2 == null) continue;
            attribute.setAttributeValue(replace2);
        }
        if (element.getText() != null && !"".equals(element.getText()) && (replace = this.replace(element.getText(), templateEndpoint)) != null) {
            element.setText(replace);
        }
        Iterator elemItr = element.getChildElements();
        while (elemItr.hasNext()) {
            OMElement childElement = (OMElement)elemItr.next();
            this.replaceElement(templateEndpoint, childElement);
        }
    }

    private String replace(String value, TemplateEndpoint templateEndpoint) {
        if (value.startsWith("$")) {
            String param = value.substring(1);
            if (templateEndpoint.getParameters().containsKey(param) && this.parameters.contains(param)) {
                return templateEndpoint.getParameterValue(param);
            }
        }
        return null;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

