/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class Value {
    private static final Log log = LogFactory.getLog(Value.class);
    private String name = null;
    private String keyValue = null;
    private SynapseXPath expression = null;
    private List<OMNamespace> namespaceList = new ArrayList<OMNamespace>();

    public Value(String staticKey) {
        this.keyValue = staticKey;
    }

    public Value(SynapseXPath expression) {
        this.expression = expression;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public SynapseXPath getExpression() {
        if (this.expression == null && this.keyValue != null && this.hasExprTypeKey()) {
            try {
                this.expression = new SynapseXPath(this.keyValue.substring(1, this.keyValue.length() - 1));
                for (OMNamespace aNamespaceList : this.namespaceList) {
                    this.expression.addNamespace(aNamespaceList);
                }
            }
            catch (JaxenException e) {
                this.expression = null;
                this.handleException("Can not evaluate escaped expression..");
            }
        }
        return this.expression;
    }

    public String evaluateValue(MessageContext synCtx) {
        if (this.keyValue != null) {
            return this.keyValue;
        }
        if (this.expression != null) {
            return this.expression.stringValueOf(synCtx);
        }
        this.handleException("Can not evaluate the key: key should be static or dynamic key");
        return null;
    }

    public Object evaluateObjectValue(MessageContext synCtx) {
        if (this.keyValue != null) {
            return this.keyValue;
        }
        if (this.expression != null) {
            return this.getObjectValue(synCtx);
        }
        this.handleException("Unable to resolve the value: " + this.toString());
        return null;
    }

    private Object getObjectValue(MessageContext synCtx) {
        try {
            Object result = this.expression.selectSingleNode(synCtx);
            if (result instanceof OMText) {
                return ((OMText)result).getText();
            }
            if (result instanceof OMElement) {
                return ((OMElement)result).getText();
            }
            if (result instanceof OMDocument) {
                return ((OMDocument)result).getOMDocumentElement().toString();
            }
            if (result instanceof OMAttribute) {
                return ((OMAttribute)result).getAttributeValue();
            }
            return result;
        }
        catch (JaxenException e) {
            this.handleException("Failed to evaluate the XPath expression: " + (Object)((Object)this.expression), (Exception)((Object)e));
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    public boolean hasExprTypeKey() {
        return this.keyValue != null && this.keyValue.startsWith("{") && this.keyValue.endsWith("}");
    }

    public boolean hasPropertyEvaluateExpr() {
        return this.keyValue != null && this.keyValue.contains("get-property");
    }

    public Object evalutePropertyExpression(MessageContext synCtx) {
        SynapseXPath expr = null;
        try {
            expr = new SynapseXPath(this.keyValue.substring(1, this.keyValue.length() - 1));
            for (OMNamespace aNamespaceList : this.namespaceList) {
                expr.addNamespace(aNamespaceList);
            }
            String result = expr.stringValueOf(synCtx);
            SynapseXPath expression = new SynapseXPath(result);
            for (OMNamespace aNamespaceList : this.namespaceList) {
                expression.addNamespace(aNamespaceList);
            }
            return expression;
        }
        catch (Exception e) {
            this.handleException("Can not evaluate escaped expression : " + expr);
            return this.expression;
        }
    }

    public void setNamespaces(OMElement elem) {
        Iterator namespaces = elem.getNamespacesInScope();
        while (namespaces.hasNext()) {
            OMNamespace ns = (OMNamespace)namespaces.next();
            this.namespaceList.add(ns);
        }
    }

    public String toString() {
        return "Value {name ='" + this.name + '\'' + (this.keyValue != null ? ", keyValue ='" + this.keyValue + '\'' : "") + (this.expression != null ? ", expression =" + (Object)((Object)this.expression) : "") + '}';
    }
}

