/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.util.Locale;
import org.apache.woden.ErrorHandler;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorHandlerImpl;
import org.apache.woden.internal.ErrorInfoImpl;
import org.apache.woden.internal.MessageFormatter;
import org.apache.woden.internal.util.PropertyUtils;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;

public class ErrorReporterImpl
implements ErrorReporter {
    protected static final String LOCALE_LANGUAGE = "org.apache.woden.locale-language";
    protected static final String ERROR_HANDLER_NAME = "org.apache.woden.error-handler-name";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "org.apache.woden.continue-after-fatal-error";
    private static final String CORE_RESOURCE_BUNDLE = "org.apache.woden.internal.Messages";
    private Locale fLocale;
    private MessageFormatter fMessageFormatter = new MessageFormatter();
    private ErrorHandler fDefaultErrorHandler = new ErrorHandlerImpl();
    private ErrorHandler fErrorHandler;
    private ExtensionRegistry fExtensionRegistry;

    public ErrorReporterImpl() throws WSDLException {
        String errorHandlerName;
        String localeLanguage = PropertyUtils.findProperty(LOCALE_LANGUAGE);
        if (localeLanguage != null) {
            this.fLocale = new Locale(localeLanguage);
        }
        if ((errorHandlerName = PropertyUtils.findProperty(ERROR_HANDLER_NAME)) != null) {
            try {
                Class<?> cl = Class.forName(errorHandlerName);
                this.fErrorHandler = (ErrorHandler)cl.newInstance();
            }
            catch (Exception e) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating the customer error handler.", e);
            }
        } else {
            this.fErrorHandler = null;
        }
    }

    public void reportError(ErrorLocator errLoc, String errorId, Object[] arguments, short severity) throws WSDLException {
        this.reportError(errLoc, errorId, arguments, severity, null);
    }

    public void reportError(ErrorLocator errLoc, String errorId, Object[] arguments, short severity, Exception exception) throws WSDLException {
        String[] names = this.getResourceBundleNames();
        String message = this.fMessageFormatter.formatMessage(this.fLocale, errorId, arguments, names);
        this.reportError(errLoc, errorId, message, severity, exception);
    }

    public void reportError(ErrorLocator errLoc, String errorId, String message, short severity) throws WSDLException {
        this.reportError(errLoc, errorId, message, severity, null);
    }

    public void reportError(ErrorLocator errLoc, String errorId, String message, short severity, Exception exception) throws WSDLException {
        ErrorHandler eh;
        ErrorInfoImpl errorInfo = new ErrorInfoImpl(errLoc, errorId, message, exception);
        ErrorHandler errorHandler = eh = this.fErrorHandler != null ? this.fErrorHandler : this.fDefaultErrorHandler;
        if (severity == 1) {
            eh.warning(errorInfo);
        } else if (severity == 2) {
            eh.error(errorInfo);
        } else {
            if (severity == 3) {
                eh.fatalError(errorInfo);
                if (exception == null) {
                    throw new WSDLException("INVALID_WSDL", "Fatal WSDL error:\n" + ((Object)errorInfo).toString());
                }
                if (exception instanceof WSDLException) {
                    throw (WSDLException)exception;
                }
                throw new WSDLException("OTHER_ERROR", "Fatal error.", exception);
            }
            throw new IllegalArgumentException("Invalid severity: " + severity);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler != null ? this.fErrorHandler : this.fDefaultErrorHandler;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public String getFormattedMessage(String key, Object[] arguments) {
        String[] names = this.getResourceBundleNames();
        String message = this.fMessageFormatter.formatMessage(this.fLocale, key, arguments, names);
        return message;
    }

    void setExtensionRegistry(ExtensionRegistry extensionRegistry) {
        this.fExtensionRegistry = extensionRegistry;
    }

    private String[] getResourceBundleNames() {
        if (this.fExtensionRegistry != null) {
            return this.fExtensionRegistry.queryResourceBundleNames();
        }
        return new String[]{CORE_RESOURCE_BUNDLE};
    }
}

