/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops.compile;

import org.apache.sysml.hops.Hop;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.runtime.DMLRuntimeException;

public enum JobType {
    INVALID(-1, "INVALID", false, false, false),
    ANY(0, "ANY", false, false, false),
    GMR(1, "GMR", false, false, false),
    DATAGEN(2, "DATAGEN", true, false, false),
    REBLOCK(3, "REBLOCK", false, false, false),
    MMCJ(4, "MMCJ", false, true, false),
    MMRJ(5, "MMRJ", false, false, false),
    COMBINE(6, "COMBINE", false, false, true),
    SORT(7, "SORT", false, true, true),
    CM_COV(8, "CM_COV", false, false, false),
    GROUPED_AGG(9, "GROUPED_AGG", false, false, false),
    DATA_PARTITION(11, "DATAPARTITION", false, false, true),
    CSV_REBLOCK(12, "CSV_REBLOCK", false, false, false),
    CSV_WRITE(13, "CSV_WRITE", false, false, true),
    GMRCELL(14, "GMRCELL", false, false, false);

    private static int maxJobID;
    private final int id;
    private final String name;
    private final boolean emptyInputsAllowed;
    private final boolean allowsSingleShuffleInstruction;
    private final boolean allowsNoOtherInstructions;

    private JobType(int id, String name, boolean aei, boolean assi, boolean anoi) {
        this.id = id;
        this.name = name;
        this.emptyInputsAllowed = aei;
        this.allowsSingleShuffleInstruction = assi;
        this.allowsNoOtherInstructions = anoi;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean areEmptyInputsAllowed() {
        return this.emptyInputsAllowed;
    }

    public boolean allowsSingleShuffleInstruction() {
        return this.allowsSingleShuffleInstruction;
    }

    public boolean allowsNoOtherInstructions() {
        return this.allowsNoOtherInstructions;
    }

    public Lop.Type getShuffleLopType() {
        if (!this.allowsSingleShuffleInstruction) {
            throw new DMLRuntimeException("Shuffle Lop Type is not defined for a job (" + this.getName() + ") with allowsSingleShuffleInstruction=false.");
        }
        if (this.getName().equals("MMCJ")) {
            return Lop.Type.MMCJ;
        }
        if (this.getName().equals("MMRJ")) {
            return Lop.Type.MMRJ;
        }
        if (this.getName().equals("SORT")) {
            return Lop.Type.SortKeys;
        }
        throw new DMLRuntimeException("Shuffle Lop Type is not defined for a job (" + this.getName() + ") that allows a single shuffle instruction.");
    }

    public static JobType findJobTypeFromLop(Lop node) {
        Lop.Type lt = node.getType();
        switch (lt) {
            case DataGen: {
                return DATAGEN;
            }
            case ReBlock: {
                return REBLOCK;
            }
            case Grouping: {
                return GMR;
            }
            case MMCJ: {
                return MMCJ;
            }
            case MMRJ: {
                return MMRJ;
            }
            case MMTSJ: {
                return GMR;
            }
            case SortKeys: {
                return SORT;
            }
            case CentralMoment: 
            case CoVariance: {
                return CM_COV;
            }
            case GroupedAgg: {
                return GROUPED_AGG;
            }
            case CombineBinary: 
            case CombineTernary: {
                return COMBINE;
            }
            case DataPartition: {
                return DATA_PARTITION;
            }
            case CSVReBlock: {
                return CSV_REBLOCK;
            }
            case Data: {
                Hop.FileFormatTypes fmt = ((Data)node).getFileFormatType();
                return fmt == Hop.FileFormatTypes.CSV ? CSV_WRITE : null;
            }
        }
        return null;
    }

    public boolean isCompatibleWithParentNodes() {
        if (!this.allowsSingleShuffleInstruction) {
            throw new DMLRuntimeException("isCompatibleWithParentNodes() can not be invoked for a job (" + this.getName() + ") with allowsSingleShuffleInstruction=false.");
        }
        if (this.getName().equals("MMCJ")) {
            return false;
        }
        if (this.getName().equals("MMRJ") || this.getName().equals("SORT")) {
            return true;
        }
        throw new DMLRuntimeException("Implementation for isCompatibleWithParentNodes() is missing for a job (" + this.getName() + ") that allows a single shuffle instruction.");
    }

    public boolean allowsRecordReaderInstructions() {
        return this.getName().equals("GMR");
    }

    public int getBase() {
        if (this.id == -1) {
            return 0;
        }
        if (this.id == 0) {
            return (int)Math.pow(2.0, maxJobID) - 1;
        }
        return (int)Math.pow(2.0, this.id - 1);
    }

    public static int getNumJobTypes() {
        return JobType.values().length;
    }

    static {
        maxJobID = -1;
        for (JobType jt : JobType.values()) {
            if (jt.getId() <= maxJobID) continue;
            maxJobID = jt.getId();
        }
    }
}

